package com.tykj.dev.device.file.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DocumentDevice.java
 * @Description 单据涉及装备实体
 * @createTime 2021年01月25日 10:19:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "单据涉及装备实体", description = "单据涉及装备实体")
public class DocumentDevice {

    @ApiModelProperty(name = "序号")
    private Integer code;

    @ApiModelProperty(name = "型号")
    private String model;

    @ApiModelProperty(name = "部件")
    private String parts;

    @ApiModelProperty(name = "类型")
    private String category;

    @ApiModelProperty(name = "密级")
    private String securityClassification;

    @ApiModelProperty(name = "应用领域")
    private String applicationField;

    @ApiModelProperty(name = "数量")
    private Integer count;

    @ApiModelProperty(name = "装备序列号")
    private String deviceSerialNumber;

    @ApiModelProperty(name = "生产序列号")
    private String productionSerialNumber;

    @ApiModelProperty(name = "备注")
    private String remark;

    public Integer getLen(){
        return deviceSerialNumber.length();
    }

}
