package com.tykj.dev.device.file.entity;

import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Documents.java
 * @Description 出库入库单据样式
 * @createTime 2021年01月25日 10:16:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "出库入库单据样式", description = "出库入库单据属性实体")
public class Documents {
    @ApiModelProperty(name = "单据号")
    private String number;

    @ApiModelProperty(name = "单据标题")
    private String title;

    @ApiModelProperty(name = "接收单位")
    private String receiveUnit;

    @ApiModelProperty(name = "批复文号")
    private String replyNum;

    @ApiModelProperty(name = "相关装备")
    private List<DocumentDevice> documentDevices;

    @ApiModelProperty(name = "发件单位")
    private String senderUnit;

    @ApiModelProperty(name = "签章数据")
    private String srcA;

    @ApiModelProperty(name = "签章数据")
    private String srcB;

    @ApiModelProperty(name = "发件方经办人")
    private String nameA;

    @ApiModelProperty(name = "发件方经办人")
    private String nameA1;

    @ApiModelProperty(name = "接收方人员")
    private String nameB;

    @ApiModelProperty(name = "接收方人员")
    private String nameB1;

    @ApiModelProperty(name = "后端转换使用")
    private List<ScriptSaveVo> scriptSaveVos;

    public Documents(String number, String title, String receiveUnit, String replyNum, String senderUnit, String srcA, String srcB, String nameA, String nameA1, String nameB, String nameB1, List<ScriptSaveVo> scriptSaveVos) {
        this.number = number;
        this.title = title;
        this.receiveUnit = receiveUnit;
        this.replyNum = replyNum;
        this.senderUnit = senderUnit;
        this.srcA = srcA;
        this.srcB = srcB;
        this.nameA = nameA;
        this.nameA1 = nameA1;
        this.nameB = nameB;
        this.nameB1 = nameB1;
        this.scriptSaveVos = scriptSaveVos;
    }
}
