package com.tykj.dev.device.file.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName WorkHandoverDevice.java
 * @Description TODO
 * @createTime 2021年03月08日 10:40:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "工作交接单据", description = "工作交接单据提供数据")
public class WorkHandoverDevice {

    @ApiModelProperty(value = "序列号" ,example = "1")
    private Integer code;

    @ApiModelProperty(value = "型号", example = "bmxx")
    private String model;

    @ApiModelProperty(value = "名称", example = "BM-1")
    private String name;

    @ApiModelProperty(value = "装备类型总数", example = "100")
    private Integer deviceNumber;

    @ApiModelProperty(value = "在库数量", example = "10")
    private Integer inLibraryNum;

    @ApiModelProperty(value = "维修数量", example = "10")
    private Integer repairNum;

    @ApiModelProperty(value = "销毁数量", example = "10")
    private Integer destoryNum;

    @ApiModelProperty(value = "退役数量", example = "10")
    private Integer retiredNum;

    @ApiModelProperty(value = "报废数量", example = "10")
    private Integer scrappedNum;

    @ApiModelProperty(value = "运输中数量", example = "10")
    private Integer allotNum;

    @ApiModelProperty(value = "使用数量", example = "10")
    private Integer useNum;

    @ApiModelProperty(value = "其他数据",example = "10")
    private Integer otherNum=0;

    @ApiModelProperty(value = "序列号区间")
    public String seqs;

    public Integer getLen(){
        return seqs.length();
    }
}
