package com.tykj.dev.device.file.service;

import com.tykj.dev.device.file.entity.FileRet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName FilesUtil.java
 * @Description 文件工具类
 * @createTime 2021年01月08日 15:24:00
 */
public class FilesUtil {
    public static List<FileRet> stringFileToList(String fileString){
        if (fileString!=null && !"".equals(fileString)) {
            List<FileRet> fileRetList = new ArrayList<>();
            String[] fileRets = fileString.substring(3).split("<\\*>");
            List<String> strings = Arrays.asList(fileRets);
            strings.forEach(
                    file -> {
                        System.out.println(file);
                        String[] files = file.split(",");
                        FileRet fileRet = new FileRet();
                        fileRet.setName(files[0]);
                        fileRet.setFilePath(files[1]);
                        fileRet.setPreviewPath(files[2]);
                        fileRetList.add(fileRet);
                    }
            );
            return fileRetList;
        }else {
            return new ArrayList<>();
        }
    }

    public static String stringFileToList(List<FileRet> fileRets){
        StringBuffer fileString = new StringBuffer();
        if (fileRets!=null) {
            fileRets.forEach(
                    fileRet -> fileString.append("<*>").append(fileRet.getName())
                            .append(",")
                            .append(fileRet.getFilePath())
                            .append(",")
                            .append(fileRet.getPreviewPath())
            );
            return fileString.toString();
        }else {
            return fileString.toString();
        }
    }
    public static void main(String[] args) {
        stringFileToList("<*>123123,123123,123123<*>222,222,222");
        stringFileToList(stringFileToList("<*>123123,123123,123123<*>222,222,222"));
    }

}
