package com.tykj.dev.device.file.service.Impl;

import com.tykj.dev.device.file.entity.DocumentDevice;
import com.tykj.dev.device.file.entity.Documents;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.PdfService;
import com.tykj.dev.device.file.util.JavaToPdfHtmlFreeMarker;
import com.tykj.dev.device.library.subject.vo.Script;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName PdfServiceImpl.java
 * @Description TODO
 * @createTime 2021年03月17日 16:03:00
 */
@Service
@Slf4j
public class PdfServiceImpl implements PdfService {
    @Value("${file.path}")
    public String url;
    @Value("${preview.path}")
    public String preview;

    @Override
    public FileRet billPdf(Documents documents) {
        documents.setDocumentDevices(documents.getScriptSaveVos().stream().map(this::toDocDev).collect(Collectors.toList()));
        String[] content = JavaToPdfHtmlFreeMarker.freeMarkerRender(documents,url+"htmlModel/");
        log.info("[file] 调用了生成出入单据对接口 documents");
        return JavaToPdfHtmlFreeMarker.createPdf(content,url,preview,"documents/");
    }

    private DocumentDevice toDocDev(ScriptSaveVo scriptSaveVo){
       return new DocumentDevice(null,scriptSaveVo.getModel(),null,scriptSaveVo.getType(),scriptSaveVo.getSecretLevel(),scriptSaveVo.getInvisibleRange(),scriptSaveVo.getNum(),scriptSaveVo.getSeqNumber(),null,scriptSaveVo.getRemark());
    }
}
