package com.tykj.dev.device.file.util;

import com.deepoove.poi.XWPFTemplate;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName util.java
 * @Description TODO
 * @createTime 2021年01月24日 14:19:00
 */

public class WordUtil {



    /**
     * 根据模板填充内容生成word
     * 调用方法参考下面的main方法，详细文档参考官方文档
     * Poi-tl模板引擎官方文档：http://deepoove.com/poi-tl/
     *
     * @param templatePath word模板文件路径
     * @param fileDir      生成的文件存放地址
     * @param fileName     生成的文件名,不带格式。假如要生成abc.docx，则fileName传入abc即可
     * @param paramMap     替换的参数集合
     * @return 生成word成功返回生成的文件的路径，失败返回空字符串
     */
    public static String createWord(String templatePath, String fileDir, String fileName, Map<String, Object> paramMap) {


        // 生成的word格式
        String formatSuffix = ".docx";
        // 拼接后的文件名
        fileName = fileName + formatSuffix;

        // 生成的文件的存放路径
        if (!fileDir.endsWith("/")) {
            fileDir = fileDir + File.separator;
        }

        File dir = new File(fileDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        String filePath = fileDir + fileName;
        // 读取模板templatePath并将paramMap的内容填充进模板，即编辑模板+渲染数据
        XWPFTemplate template = XWPFTemplate.compile(templatePath).render(paramMap);
        try {
            // 将填充之后的模板写入filePath
            template.writeToFile(filePath);
            template.close();
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return filePath;
    }

    public static void main(String[] args) {
        Map<String, Object> params = new HashMap<>();
        // 渲染文本
        params.put("title1","2021年度省机要局装备使用情况报告");
        params.put("title2","2021年1月至2021年一月使用");
        params.put("total","2021年度本单位总件数11，其中入库总台数0，维修建设");
        params.put("comfirm","列装总台数0台，退装总数0台");
        params.put("unitName","省机要局");

        params.put("time","2021年10月1日");
        // 渲染图片
        // TODO 渲染其他类型的数据请参考官方文档
        String templatePath = "/Users/zjm/code/ty/spring-cloud-study-poi/src/main/resources/人物模板2.docx";
        String fileDir = "/Users/zjm/code/ty/spring-cloud-study-poi/src/main/resources/";
        String fileName = "zdd2";

        String wordPath = WordUtil.createWord(templatePath, fileDir, fileName, params);
        System.out.println("生成文档路径：" + wordPath);
    }

}
