package com.tykj.dev.device.finalcheck.entity.domain;

import com.tykj.dev.device.finalcheck.entity.vo.FinalDetailVo;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.utils.MapperUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;

/**
 * finalDetail.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/24 at 6:07 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
public class FinalDetail extends BaseEntity {

    private String model;

    private Integer type;

    private Integer vertical;

    private Integer horizontal;

    private Integer commission;

    private Integer other;

    private Integer total;

    private Integer hosting;

    private Integer received;

    private Integer sending;

    private Integer scrapped;

    private Integer reportId;

    public FinalDetailVo toVo() {
        return MapperUtils.map(this, FinalDetailVo.class);
    }
}
