package com.tykj.dev.device.finalcheck.entity.domain;

import com.tykj.dev.device.finalcheck.entity.vo.FinalDetailVo;
import com.tykj.dev.device.finalcheck.entity.vo.FinalReportVo;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.utils.MapperUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * finalReport.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/24 at 6:14 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Entity
public class FinalReport extends BaseEntity {

    private String name;

    private String unitName;

    private LocalDate startTime;

    private LocalDate endTime;

    private LocalDateTime reportTime;

    private String operator;

    public FinalReportVo toVo(List<FinalDetail> details) {
        FinalReportVo reportVo = MapperUtils.map(this, FinalReportVo.class);
        List<FinalDetailVo> detailVos = MapperUtils.mapAll(details, FinalDetailVo.class);
        reportVo.setDetails(detailVos);
        return reportVo;
    }
}
