package com.tykj.dev.device.finalcheck.entity.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDate;

/**
 * TimeParam.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/28 at 11:24 上午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "时间参数")
@JsonPropertyOrder({"startTime", "endTime"})
public class TimeParam {

    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @ApiModelProperty(value = "决算开始时间", example = "2020-01-02")
    private LocalDate startTime;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonDeserialize(using = LocalDateDeserializer.class)
    @ApiModelProperty(value = "决算结束时间", example = "2020-11-02")
    private LocalDate endTime;
}
