package com.tykj.dev.device.finalcheck.entity.vo;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * finalDetailVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/24 at 5:41 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "决算报告细节")
@ExcelTarget("FinalReport")
public class FinalDetailVo {

    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("型号")
    private String model;

    @ApiModelProperty("部件")
    private Integer type;

    @ApiModelProperty("纵向")
    private Integer vertical;

    @ApiModelProperty("横向")
    private Integer horizontal;

    @ApiModelProperty("委托")
    private Integer commission;

    @ApiModelProperty("其他")
    private Integer other;

    @ApiModelProperty("合计")
    private Integer total;

    @ApiModelProperty("代管")
    private Integer hosting;

    @ApiModelProperty("收到")
    private Integer received;

    @ApiModelProperty("发出")
    private Integer sending;

    @ApiModelProperty("报废")
    private Integer scrapped;


}
