package com.tykj.dev.device.finalcheck.service;

import com.tykj.dev.device.finalcheck.entity.vo.FinalReportSelectVo;
import com.tykj.dev.device.finalcheck.entity.vo.FinalReportVo;
import org.springframework.data.domain.Page;

import java.time.LocalDate;

/**
 * FinalCheckService.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/28 at 2:14 下午
 */
public interface FinalCheckService {

    /**
     * 发起指定时间范围的装备的决算
     *
     * @param startTime 决算开始时间
     * @param endTime   决算结束时间
     * @return {@link FinalReportVo}
     */
    FinalReportVo generateReport(LocalDate startTime, LocalDate endTime);

    /**
     * 根据关键字查询报告列表(不附带detail)
     * @return {@link FinalReportVo} 's List
     */
    Page<FinalReportVo> findAllWithoutDetail(FinalReportSelectVo finalReportSelectVo);

    /**
     * 根据主键id查询报告
     *
     * @param id 主键id
     * @return {@link FinalReportVo}
     */
    FinalReportVo findReportById(Integer id);

}
