package com.tykj.dev.device.library.repository;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import javax.transaction.Transactional;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@SuppressWarnings("SqlResolve")
public interface DeviceLibraryDao extends JpaRepository<DeviceLibrary, Integer>, JpaSpecificationExecutor<DeviceLibrary> {

    List<DeviceLibrary> getAllByModel(String model);

    List<DeviceLibrary> getAllByOwnUnit(String unit);

    List<DeviceLibrary> getAllByTypeAndNameAndModel(Integer type, String name, String model);

    List<DeviceLibrary> findAllBySeqNumberIn(List<String> seqNumbers);

    /**
     * 根据装备型号与装备所在地(多个地区)查询装备数量
     *
     * @param model     装备型号
     * @param locations 装备所在地列表
     * @return 装备数量
     */
    int countByModelAndLocationUnitIn(String model, List<String> locations);

    /**
     * 根据装备型号与装备所在地(一个地区)查询装备数量
     *
     * @param model    装备型号
     * @param location 装备所在地
     * @return 装备数量
     */
    int countByModelAndLocationUnit(String model, String location);


    List<DeviceLibrary> getAllByPartParentIdAndIsPart(Integer parentId, Integer isPart);

    List<DeviceLibrary> getAllByRfidCardId(String rfidCardId);

    @Query(nativeQuery = true, value = "select * from device_library where id in :idList")
    List<DeviceLibrary> getDeviceLibraryEntitiesByIdIn(@Param("idList") List<Integer> idList);

    List<DeviceLibrary> getAllByRfidSurfaceId(String rfid);

    @Query("select o from DeviceLibrary o where o.ownUnit= :unitName and o.createTime >= :startTime and o.createTime <= :endTime")
    List<DeviceLibrary> findAllByUnitBetweenTime(String unitName, Date startTime, Date endTime);

    List<DeviceLibrary> getAllByPackingId(Integer packingId);

    List<DeviceLibrary> getAllBySeqNumber(String seq);

    boolean existsAllByPackingIdInAndOwnUnitIn(List<Integer> packingIds,List<String> unitNames);

    Integer countAllByModelAndOwnUnitInAndLifeStatusNotIn(String model,List<String> unitNames,List<Integer> lifeStatus);

    Integer countAllByModelAndOwnUnitInAndLifeStatusIn(String model,List<String> unitNames,List<Integer> lifeStatus);

    Integer countAllByPackingIdInAndOwnUnitInAndLifeStatusIn(List<Integer> packingIds,List<String> unitNames,List<Integer> lifeStatus);

    Integer countAllBySeqNumberInAndOwnUnitInAndLifeStatusIn(List<String> seqNumbers,List<String> unitNames,List<Integer> lifeStatus);


    List<DeviceLibrary> findAllByPackingIdInAndOwnUnit(List<Integer> packingIds,String unitNames);

    List<DeviceLibrary> findAllByPackingIdInAndOwnUnitIn(List<Integer> packingIds,List<String> unitNames);

    List<DeviceLibrary> findAllByOwnUnitAndLocationUnitAndLifeStatus(String ownUnitName,String locationUnitName,Integer status);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus where o.id in :idList")
    int upDateLeftStatus(Integer lifeStatus,@Param("idList") List<Integer> idList);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus where o.seqNumber in :seqNumbers")
    int upDateSeqNumbersLeftStatus(Integer lifeStatus,@Param("seqNumbers") List<String> seqNumbers);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.lockStatus=:lock where o.id in :idList")
    int upDateLeftStatusAndLockStatus(Integer lifeStatus,Integer lock,@Param("idList") List<Integer> idList);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.locationUnit = :unitName,o.ownUnit = :unitName ,o.lockStatus=:lock where o.id in :idList")
    int upDateLeftStatusAndUnitNameAndLockStatus(Integer lifeStatus,String unitName,Integer lock,@Param("idList") List<Integer> idList);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.locationUnit = :unitName,o.ownUnit = :unitName ,o.lockStatus=:lock where o.seqNumber in :seqNumbers")
    int upDateSeqNumbersLeftStatusAndUnitNameAndLockStatus(Integer lifeStatus,String unitName,Integer lock,@Param("seqNumbers") List<String> seqNumbers);

    @Transactional
    @Modifying
    @Query("update DeviceLibrary o set o.lifeStatus = :lifeStatus ,o.ownUnit = :unitName ,o.locationUnit = :unitName where o.id in :idList")
    int upDateLeftStatusAndOwnUnitName(Integer lifeStatus,String unitName,@Param("idList") List<Integer> idList);

    List<DeviceLibrary> findAllByLifeStatus(Integer status);
}

