package com.tykj.dev.device.library.repository;

import com.tykj.dev.device.library.subject.domin.DeviceLog;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface DeviceLogDao extends JpaRepository<DeviceLog, Integer>, JpaSpecificationExecutor<DeviceLog> {

    /**
     * @param deviceId 装备id
     * @param type     0:装备日志,1:配套设备日志
     *                 通过装备id和日志类型查询装备履历
     */
    List<DeviceLog> getAllByDeviceIdAndType(Integer deviceId, Integer type);

}
