package com.tykj.dev.device.library.service;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLibrarySelectVo;
import com.tykj.dev.device.library.subject.vo.DeviceStatisticsVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
public interface DeviceLibraryService {

    /**
     * @param deviceLibraryEntity 添加装备
     */
    DeviceLibrary addEntity(DeviceLibrary deviceLibraryEntity);

    /**
     * @param deviceLibraries 异步上链
     */
    void sendHash(List<DeviceLibrary> deviceLibraries);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取装备分页
     */
    Page<DeviceLibrary> getPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取标签管理分页
     */
    Page<DeviceLibrary> getTagPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     */
    List<DeviceLibrary> getCoreDevicePage(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取装备统计分页
     */
    List<DeviceStatisticsVo> getDeviceStatisticsPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * 获取所有存在的装备名称
     */
    List<String> getAllName();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取单位装备列表
     */
    List<DeviceLibrary> getList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取所有区域装备列表
     */
    List<DeviceLibrary> getAllList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 获取单位自查装备列表
     */
    List<DeviceLibrary> getCheckList();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取可配发装备列表
     */
    List<DeviceLibrary> getAllotList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param id 入库单id
     *           根据入库单Id查询装备列表
     */
    List<DeviceLibrary> getListByBillId(Integer id);

    /**
     * @param deviceLibraryEntity 更新装备信息
     */
    DeviceLibrary update(DeviceLibrary deviceLibraryEntity);

    /**
     * @param id 装备主键Id
     *           通过id查询某件装备
     */
    DeviceLibrary getOne(Integer id);

    /**
     * @param id 装备主键id
     *           逻辑删除某件装备
     */
    void delete(Integer id);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              不以父子结构返回单位装备列表
     */
    List<DeviceLibrary> getListWithoutParent(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 查询拥有装备的所有单位
     */
    List<String> getAllUnit();

    /**
     * 查询在库所有装备的型号
     */
    List<String> getAllInLibraryModels();

    /**
     * 查询可清退装备
     */
    List<DeviceLibrary> getSendBackDevice(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 判断装备状态是否在库
     */
    void isInStock(List<Integer> ids);

    /**
     * 判断装备状态是否待退役
     */
    void isWaitRetired(List<Integer> ids);

    /**
     * 判断装备状态是否在库或待退役
     */
    void isInStockOrWaitRetired(List<Integer> ids);

    /**
     * 判断装备状态是否丢失
     * @param ids
     */
    void isNotLoss(List<Integer> ids);

    /**
     * 判断装备状态是否在库或维修中
     */
    void isInStockOrRepairing(List<Integer> ids);

    int getDeviceCount();

    /**
     * 获取所有装备map
     */
    Map<Integer,DeviceLibrary> getAllDeviceMap();

    /**
     * 根据单位 以及生命状态集合 查询设备数量
     */
    Integer countAllRepel(List<Integer> fieldingIds,List<String> unitNames,List<String> seqNums,List<Integer> lifeStatusList);

    List<DeviceLibrary> findAllBySeqNumber(List<String> seqNumbers);

}
