package com.tykj.dev.device.library.subject.Dto;

import com.tykj.dev.device.library.subject.domin.DeviceLog;
import com.tykj.dev.device.library.subject.vo.DeviceLogUserVo;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.SpringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeviceLogDto {

    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(value = "日志类型(默认0为装备日志,1为设备日志)")
    private Integer type = 0;

    @ApiModelProperty(value = "装备id")
    private Integer deviceId;

    @ApiModelProperty(value = "操作描述")
    private String remark;

    @ApiModelProperty(value = "附件信息")
    private List<FileVo> fileVoList = new ArrayList<>();

    @ApiModelProperty(value = "操作人")
    private Integer createUserId;

    @ApiModelProperty(value = "操作时间")
    private Date createTime;

    public DeviceLogDto(Integer deviceId, String remark, List<FileVo> fileVoList, Integer createUserId) {
        this.deviceId = deviceId;
        this.remark = remark;
        this.fileVoList = fileVoList;
        this.createUserId = createUserId;
    }

    public DeviceLogDto(Integer deviceId, String remark, List<FileVo> fileVoList) {
        this.deviceId = deviceId;
        this.remark = remark;
        this.fileVoList = fileVoList;
    }

    public DeviceLogDto(Integer type, Integer deviceId, String remark, List<FileVo> fileVoList) {
        this.type = type;
        this.deviceId = deviceId;
        this.remark = remark;
        this.fileVoList = fileVoList;
    }

    /**
     * dto类转化为do类
     */
    public DeviceLog toDo() {
        DeviceLog deviceLog = new DeviceLog();
        deviceLog.setType(this.type);
        deviceLog.setDeviceId(this.deviceId);
        deviceLog.setRemark(this.remark);
        if (this.createUserId!=null){
            deviceLog.setCreateUserId(createUserId);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ǵ");
        if (this.fileVoList != null && this.fileVoList.size() > 0) {
            for (FileVo f : this.fileVoList) {
                stringBuffer.append(f.getFileName());
                stringBuffer.append("Ǒ");
                stringBuffer.append(f.getFileUrl());
                stringBuffer.append("Ǒ");
                stringBuffer.append(f.getTitle());
                stringBuffer.append("Ǵ");
            }
        }
        deviceLog.setFileDetail(stringBuffer.toString());
        return deviceLog;
    }

    /**
     * dto类转化为vo类
     */
    public DeviceLogUserVo toVo() {
        UserPublicService userPublicService = SpringUtils.getBean("userPublicServiceImpl");
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        DeviceLogUserVo deviceLogUserVo = modelMapper.map(this, DeviceLogUserVo.class);
        //set vo字段
        if (userPublicService != null && this.createUserId != null) {
            User user = userPublicService.getOne(this.createUserId);
            deviceLogUserVo.setUser(user.getName());
            deviceLogUserVo.setUnit(userPublicService.findUnitsNameByUserId(this.createUserId));
            deviceLogUserVo.setPhoneNum(user.getMobile());
        }
        return deviceLogUserVo;
    }
}
