package com.tykj.dev.device.library.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Repository
@Data
@ApiModel("装备编辑类")
public class DeviceEditVo {

    @ApiModelProperty(value = "装备库更新信息")
    private DeviceLibraryUpdateVo updateVoList;

    @ApiModelProperty(value = "新增配件信息列表")
    private List<Integer> partAddIdList;

    @ApiModelProperty(value = "删除相关配件id")
    private List<Integer> partIdDeleteList;

    @NotNull(message = "deviceId不能为空")
    @Min(value = 1,message = "deviceId不能小于1")
    @ApiModelProperty(value = "装备id", example = "1")
    private Integer deviceId;

    @Min(value = 1,message = "id不能小于1")
    @ApiModelProperty(value = "换新维修详情id", example = "1")
    private Integer id;
}
