package com.tykj.dev.device.library.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备编辑更新类")
@Repository
public class DeviceLibraryUpdateVo {

    @ApiModelProperty(value = "型号", example = "bmxx")
    public String model;
    @ApiModelProperty(value = "类型", example = "1")
    public Integer type;
    @ApiModelProperty(value = "密级", example = "1")
    public Integer secretLevel;
    @ApiModelProperty(value = "可见范围(应用领域)", example = "1")
    public Integer invisibleRange;
    @ApiModelProperty(value = "名称", example = "BM-1")
    public String name;
    @ApiModelProperty(value = "配用范围", example = "1")
    public Integer matchingRange;
    @ApiModelProperty(value = "所属单位", example = "省机要局")
    public String ownUnit;
    @ApiModelProperty(value = "所在单位", example = "省机要局")
    public String locationUnit;
    /**
     * 生命状态,0-入库待审核,1-入库审核失败,2-在库,3-运输中,4-维修中,5,维修失败(报废在省库),6-清退,7-待退装,8-退装,9-待销毁,10-已销毁,11-丢失,12-退役,13-报废不在省库,14-使用
     */
    @ApiModelProperty(value = "生命状态", example = "1")
    public Integer lifeStatus;
    @ApiModelProperty(value = "需要更新信息的装备id")
    private Integer deviceId;
    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;
    @ApiModelProperty(value = "生产序列号")
    private String prodNumber;
    @ApiModelProperty(value = "入库类型，1-横向，2-纵向")
    private Integer storageType;
    @ApiModelProperty(value = "管理状态,0-不再所属单位,1-在所属单位")
    private Integer manageStatus;

}
