package com.tykj.dev.device.library.subject.vo;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备类")
public class DeviceVo {

    private Integer id;

    private Integer isPart;

    private Integer lockStatus;

    @ApiModelProperty(value = "类型")
    private Integer type;

    private Integer invisibleRange;

    private Integer secretLevel;

    private Integer allotType;

    private Integer matchingRange;

    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;
    /**
     * 装备名称
     */
    @ApiModelProperty(value = "装备名称")
    private String name;

    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;

    /**
     * rfid表面号
     */
    @ApiModelProperty(value = "rfid表面号")
    private String rfidSurfaceId;

    /**
     * 所在单位
     */
    @ApiModelProperty(value = "所在单位")
    private String locationUnit;
    /**
     * 所属单位
     */
    @ApiModelProperty(value = "所属单位")
    private String ownUnit;

    private Integer lifeStatus;

    @ApiModelProperty(value = "备注")
    private String record;

    @ApiModelProperty(value = "密级")
    private String secretLevelName;

    @ApiModelProperty(value = "配用范围")
    private String matchingRangeName;

    @ApiModelProperty(value = "可见范围")
    private String invisibleRangeName;

    @ApiModelProperty(value = "形态")
    private String typeName;

    @ApiModelProperty(value = "生命状态")
    private String lifeStatusName;

    @ApiModelProperty(value = "入库类型")
    private String storageTypeName;

    private String allotTypeName;

    private List<DeviceLibrary> childs;
}
