package com.tykj.dev.device.loss.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.loss.entity.vo.LossAuditvo;
import com.tykj.dev.device.loss.entity.vo.RetrieveAuditvo;
import com.tykj.dev.device.loss.service.LossBillService;
import com.tykj.dev.device.loss.entity.domain.DeviceLoss;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceLossController.java
 * @Description TODO
 * @createTime 2021年01月30日 16:07:00
 */
@RestController
@Api(tags = "装备丢失", description = "装备丢失上报接口")
@AutoDocument
@RequestMapping("/loss")
public class DeviceLossController {
    @Autowired
    LossBillService lossBillService;
    @PostMapping(value ="/initiateLoss")
    @ApiOperation(value = "丢失装备上报", notes = "丢失装备上报接口")
    public ResponseEntity initiateLoss(@RequestBody DeviceLoss deviceLoss,@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        lossBillService.initiateLoss(deviceLoss,securityUser);
        return ResponseEntity.ok("上报成功");
    }


    @PostMapping(value ="/superiorAuditLoss")
    @ApiOperation(value = "上报上级单位确认接口", notes = "上报上级单位确认接口")
    public ResponseEntity initiateLoss(@RequestBody LossAuditvo lossAuditvo){
        lossBillService.superiorAuditLoss(lossAuditvo);
        return ResponseEntity.ok("确认成功");
    }

    @PostMapping(value ="/initiateRetrieve")
    @ApiOperation(value = "找回装备上报", notes = "找回装备上报接口")
    public ResponseEntity initiateRetrieve(@RequestBody DeviceLoss deviceLoss,@ApiIgnore @AuthenticationPrincipal SecurityUser securityUser){
        lossBillService.initiateRetrieve(deviceLoss,securityUser);
        return ResponseEntity.ok("上报成功");
    }

    @PostMapping(value ="/superiorAuditRetrieve")
    @ApiOperation(value = "上报上级单位确认接口", notes = "上报上级单位确认接口")
    public ResponseEntity superiorAuditRetrieve(@RequestBody RetrieveAuditvo retrieveAuditvo){
        lossBillService.superiorAuditRetrieve(retrieveAuditvo);
        return ResponseEntity.ok("确认成功");
    }
}
