package com.tykj.dev.device.loss.entity.domain;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.loss.entity.vo.DeviceLossVo;
import com.tykj.dev.device.loss.util.StringUtils;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceLoss.java
 * @Description TODO
 * @createTime 2021年01月30日 10:36:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update send_back_bill_detail set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class DeviceLoss extends BaseEntity {

    /**
     * 类型
     */
    @ApiModelProperty(value = "类型 1。丢失  2。找回")
    private Integer type;
    /**
     * 发起单位id
     */
    @ApiModelProperty(value = "发起单位id")
    private Integer unitId;

    /**
     * 发起单位名称
     */
    @ApiModelProperty(value = "发起单位名称")
    private String unitName;

    /**
     * 装备id 使用逗号分隔
     */
    @ApiModelProperty(value = "装备id 使用逗号分隔")
    private String devIds;

    /**
     *县 备注
     */
    @ApiModelProperty(value = "县 备注")
    private String  countyDes;

    /**
     * 备注单位名称 县
     */
    @ApiModelProperty(value = "备注单位名称 县")
    private String countyUnitName;

    /**
     * 市 备注
     */
    @ApiModelProperty(value = "市 备注")
    private String cityDes;

    /**
     * 备注单位名称 市
     */
    @ApiModelProperty(value = "备注单位名称 市")
    private String cityUnitName;

    /**
     * 省 备注
     */
    @ApiModelProperty(value = "省 备注")
    private String provinceDes;

    /**
     * 备注单位名称
     */
    @ApiModelProperty(value = "备注单位名称 省")
    private String provinceUnitName;

    /**
     * 丢失单据
     */
    @ApiModelProperty(value = "丢失单据")
    @Column(name = "loss_file",columnDefinition = "TEXT")
    private String lossFile;

    /**
     * 找回业务状态
     */
    @ApiModelProperty(value = "找回业务状态 1.等待审核 2.审核通过 3.审核失败")
    private Integer backStatus=1;

    /**
     * 单据集合
     */
    @ApiModelProperty(value = "单据集合")
    @Transient
    private List<FileRet> fileRetList;

    /**
     * 装备集合
     */
    @ApiModelProperty(value = "装备集合")
    @Transient
    private List<Integer> devIdsList;

    /**
     * 装备集合
     */
    @ApiModelProperty(value = "装备集合")
    @Transient
    private List<DeviceLossVo> deviceLossVoList;


//    public String getDevIds() {
//        return devIds;
//    }
//
//    public void setDevIds() {
//        this.devIds = StringUtils.ListToString(devIdsList);
//    }
//
//    public String getLossFile() {
//        return lossFile;
//    }
//
//    public void setLossFile() {
//        this.lossFile = FilesUtil.stringFileToList(fileRetList);
//    }
//
//    public List<FileRet> getFileRetList() {
//        return FilesUtil.stringFileToList(lossFile);
//    }
//
//    public void setFileRetList(List<FileRet> fileRetList) {
//        this.fileRetList = fileRetList;
//    }
//
//    public List<Integer> getDevIdsList() {
//        return StringUtils.stringToList(devIds);
//    }
//
//    public void setDevIdsList(List<Integer> devIdsList) {
//        this.devIdsList = devIdsList;
//    }
}
