package com.tykj.dev.device.loss.service.impl;

import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLog;
import com.tykj.dev.device.loss.entity.vo.LossAuditvo;
import com.tykj.dev.device.loss.entity.vo.RetrieveAuditvo;
import com.tykj.dev.device.loss.service.DeviceLossService;
import com.tykj.dev.device.loss.service.LossBillService;
import com.tykj.dev.device.loss.util.StringUtils;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.subject.entity.Area;
import com.tykj.dev.device.user.subject.entity.SecurityUser;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.service.AreaService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.DeviceLifeStatus;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.device.loss.entity.domain.DeviceLoss;
import com.tykj.dev.misc.utils.TaskDisposeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName LossBillServiceImpl.java
 * @Description TODO
 * @createTime 2021年01月30日 14:08:00
 */
@Service
public class LossBillServiceImpl implements LossBillService {

    @Autowired
    TaskService taskService;

    @Autowired
    DeviceLossService deviceLossService;

    @Autowired
    UnitsService unitsService;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;

    @Autowired
    DeviceLibraryService deviceLibraryService;

    @Autowired
    AreaService areaService;

    @Autowired
    DeviceLogService deviceLogService;

    @Autowired
    MessageService messageService;

    @Override
    public void initiateLoss(DeviceLoss deviceLoss, SecurityUser securityUser) {
        deviceLibraryService.isInStockOrWaitRetired(deviceLoss.getDevIdsList());
        deviceLoss.setDevIds(StringUtils.ListToString(deviceLoss.getDevIdsList()));
        deviceLoss.setLossFile(FilesUtil.stringFileToList(deviceLoss.getFileRetList()));
        DeviceLoss deviceLossThis= deviceLossService.save(deviceLoss);
        Units units=unitsService.findById(deviceLoss.getUnitId());
        Area area=areaService.findByid(units.getAreaId());
        if (units.getLevel() == 1) {
            end(deviceLossThis.getCreateUserId(), deviceLossThis.getId(), units.getName() + "丢失装备任务", units.getUnitId());
        } else if (units.getLevel()==2){
            Units parentUnits=unitsService.findUnitAreaId(area.getFatherId());
            newLossCityTask(parentUnits.getUnitId(), deviceLossThis.getId(), units.getName() + "丢失装备任务",securityUser.getCurrentUserInfo().getUserId());
        }else {
            Units parentUnits=unitsService.findUnitAreaId(area.getFatherId());
            newLossCountyTask(parentUnits.getUnitId(), deviceLossThis.getId(), units.getName() + "丢失装备任务",securityUser.getCurrentUserInfo().getUserId());
        }
        deviceLibraryDao.upDateLeftStatus(DeviceLifeStatus.LOSS.id,deviceLoss.getDevIdsList());
        devLogAdd(deviceLoss.getDevIdsList(),"装备报备丢失", deviceLoss.getCreateUserId());
    }



    @Override
    public void superiorAuditLoss(LossAuditvo lossAuditvo) {
        Units units=unitsService.findById(lossAuditvo.getUnitId());
        Area area=areaService.findByid(units.getAreaId());
        TaskBto taskBto=taskService.get(lossAuditvo.getTaskId());
        DeviceLoss deviceLoss=deviceLossService.findByDeviceLoss(taskBto.getBillId());

        if (units.getLevel()==1){

            TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.LOSS1301);
            deviceLoss.setProvinceUnitName(units.getName());
            deviceLoss.setProvinceDes(lossAuditvo.getDes());
            taskService.moveToEnd(taskBto);

        }else {

            TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.LOSS1300);
            Units parentUnits=unitsService.findUnitAreaId(area.getFatherId());
            deviceLoss.setCityUnitName(units.getName());
            deviceLoss.setCityDes(lossAuditvo.getDes());
            taskBto.setOwnUnit(parentUnits.getUnitId());
            taskService.moveToSpecial(taskBto,StatusEnum.LOSS1301,0);
        }
        deviceLossService.save(deviceLoss);

    }

    @Override
    public void initiateRetrieve(DeviceLoss deviceLoss,SecurityUser securityUser) {
        deviceLibraryService.isNotLoss(deviceLoss.getDevIdsList());
        deviceLoss.setDevIds(StringUtils.ListToString(deviceLoss.getDevIdsList()));
        deviceLoss.setLossFile(FilesUtil.stringFileToList(deviceLoss.getFileRetList()));
        DeviceLoss deviceLossThis= deviceLossService.save(deviceLoss);
        Units units=unitsService.findById(deviceLoss.getUnitId());
        Area area=areaService.findByid(units.getAreaId());
        if (units.getLevel() == 1) {
            endRetrieve(deviceLossThis.getCreateUserId(), deviceLossThis.getId(), units.getName() + "找回装备任务", units.getUnitId());
            deviceLibraryDao.upDateLeftStatus(DeviceLifeStatus.IN_LIBRARY.id,deviceLoss.getDevIdsList());
        } else if (units.getLevel()==2){
            Units parentUnits=unitsService.findUnitAreaId(area.getFatherId());
            newRetrieveCityTask(parentUnits.getUnitId(), deviceLossThis.getId(), units.getName() + "找回装备任务",securityUser.getCurrentUserInfo().getUserId());
        }else {
            Units parentUnits=unitsService.findUnitAreaId(area.getFatherId());
            newRetrieveCountyTask(parentUnits.getUnitId(), deviceLossThis.getId(), units.getName() + "找回装备任务",securityUser.getCurrentUserInfo().getUserId());
        }
        devLogAdd(deviceLoss.getDevIdsList(),"装备找回上报", deviceLoss.getCreateUserId());
    }

    @Override
    public void superiorAuditRetrieve(RetrieveAuditvo retrieveAuditvo) {

        Units units=unitsService.findById(retrieveAuditvo.getUnitId());
        Area area=areaService.findByid(units.getAreaId());
        TaskBto taskBto=taskService.get(retrieveAuditvo.getTaskId());
        DeviceLoss deviceLoss=deviceLossService.findByDeviceLoss(taskBto.getBillId());
        if (units.getLevel()==1){
            TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.RETRIEVE1401);
            deviceLoss.setProvinceUnitName(units.getName());
            deviceLoss.setProvinceDes(retrieveAuditvo.getDes());
            taskService.moveToEnd(taskBto);
            if (retrieveAuditvo.getType()==1){
                deviceLoss.setBackStatus(2);
                deviceLibraryDao.upDateLeftStatus(DeviceLifeStatus.IN_LIBRARY.id,StringUtils.stringToList(deviceLoss.getDevIds()));
            }else {
                deviceLoss.setBackStatus(3);
            }
        }else {
            TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.RETRIEVE1400);

            Units parentUnits=unitsService.findUnitAreaId(area.getFatherId());
            deviceLoss.setCityUnitName(units.getName());
            deviceLoss.setCityDes(retrieveAuditvo.getDes());
            if (retrieveAuditvo.getType()==1){
                taskBto.setOwnUnit(parentUnits.getUnitId());
                taskService.moveToSpecial(taskBto,StatusEnum.RETRIEVE1401,0);
            }else {
                taskService.moveToEnd(taskBto);
                deviceLoss.setBackStatus(3);
            }

        }
        deviceLossService.save(deviceLoss);
    }


    private void newRetrieveCountyTask(Integer unitId, Integer lossId, String title,Integer userID){
        List<Integer> list=new ArrayList<>();
        list.add(userID);
        list.add(0);
        taskService.start(new TaskBto(StatusEnum.RETRIEVE1400.id, title, 0, ".", lossId, BusinessEnum.RETRIEVE.id, unitId, 1, "", list));
    }

    private void newRetrieveCityTask(Integer unitId, Integer lossId, String title,Integer userID){
        List<Integer> list=new ArrayList<>();
        list.add(userID);
        list.add(0);
        taskService.start(new TaskBto(StatusEnum.RETRIEVE1401.id, title, 0, ".", lossId, BusinessEnum.RETRIEVE.id, unitId, 1, "", list));
    }

    private void endRetrieve(Integer userId, Integer lossId, String title, Integer unitId){
        List<Integer> list=new ArrayList<>();
        list.add(userId);
        taskService.start(new TaskBto(StatusEnum.END.id, title, 0, ".", lossId, BusinessEnum.RETRIEVE.id, unitId, 0, "", list));
    }


    private void newLossCountyTask(Integer unitId, Integer lossId, String title,Integer userID){
        List<Integer> list=new ArrayList<>();
        list.add(userID);
        list.add(0);
        taskService.start(new TaskBto(StatusEnum.LOSS1300.id, title, 0, ".", lossId, BusinessEnum.LOSS.id, unitId, 1, "", list));
    }

    private void newLossCityTask(Integer unitId, Integer lossId, String title,Integer userID){
        List<Integer> list=new ArrayList<>();
        list.add(userID);
        list.add(0);
        taskService.start(new TaskBto(StatusEnum.LOSS1301.id, title, 0, ".", lossId, BusinessEnum.LOSS.id, unitId, 1, "", list));
    }

    private void end(Integer userId, Integer lossId, String title, Integer unitId){
        List<Integer> list=new ArrayList<>();
        list.add(userId);
        taskService.start(new TaskBto(StatusEnum.END.id, title, 0, ".", lossId, BusinessEnum.LOSS.id, unitId, 0, "", list));
    }



    private void devLogAdd(List<Integer> ids, String remark,Integer userId){
        List<DeviceLog> logDtos=new ArrayList<>();
        deviceLibraryDao.findAllById(ids).forEach(
                deviceLibrary -> logDtos.add(new DeviceLogDto(deviceLibrary.getId(), remark,null,userId).toDo())
        );
        CompletableFuture.runAsync(() -> deviceLogService.saveAllLog(logDtos));
    }
}
