package com.tykj.dev.device.matching.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for matching_device_bill
 * 配套设备新增单
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update matching_device_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("配套设备新增单")
public class MatchingDeviceBill {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 发起人id
     */
    @ApiModelProperty(value = "发起人id")
    private Integer useraId;
    /**
     * 审核人id
     */
    @ApiModelProperty(value = "审核人id")
    private Integer userbId;
    /**
     * 设备主键id以x拼接
     */
    @Column(name = "device_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "设备主键id以x拼接")
    private String deviceDetail;
    /**
     * 新增设备状态(0:待审核,1:审核失败,2:新增成功)
     */
    @ApiModelProperty(value = "新增设备状态(0:待审核,1:审核失败,2:新增成功)")
    private Integer billStatus;
    /**
     * 附件名称
     */
    @ApiModelProperty(value = "附件名称")
    private String fileName;
    /**
     * 附件url地址
     */
    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "附件url地址")
    private String fileUrl;
    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

}
