package com.tykj.dev.device.matching.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Repository
@Data
@ApiModel("配套设备编辑类")
public class MatchingDeviceEditVo {

    @NotNull(message = "matchingDeviceId不能为空")
    @Min(value = 1,message = "matchingDeviceId不能小于1")
    @ApiModelProperty(value = "配套设备的id", example = "1")
    private Integer matchingDeviceId;

    @ApiModelProperty(value = "绑定装备的id", example = "1")
    private Integer deviceId;

    @ApiModelProperty(value = "设备类型")
    private String type;
    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;
    /**
     * 设备名称
     */
    @ApiModelProperty(value = "设备名称")
    private String name;
    /**
     * 创建单位
     */
    @ApiModelProperty(value = "创建单位")
    private String createUnit;
    /**
     * 设备序列号
     */
    @ApiModelProperty(value = "设备序列号")
    private String seqNumber;

    @ApiModelProperty(value = "生命状态", example = "1")
    private Integer lifeStatus;
}
