package com.tykj.dev.device.packing.controller;

import com.tykj.dev.config.cache.ConfigCache;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.DeviceLogUserVo;
import com.tykj.dev.device.packing.repository.PackingLibraryDao;
import com.tykj.dev.device.packing.repository.PackingLogDao;
import com.tykj.dev.device.packing.service.PackingLibraryService;
import com.tykj.dev.device.packing.service.PackingLogService;
import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import com.tykj.dev.device.packing.subject.domin.PackingLog;
import com.tykj.dev.device.packing.subject.vo.*;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.vo.TaskLogUserVo;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.bto.MessageBto;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.DeviceSeqUtil;
import com.tykj.dev.misc.utils.GetTreeUtils;
import com.tykj.dev.misc.utils.PageUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Min;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@Api(tags = "列装管理模块", description = "列装管理接口")
@AutoDocument
@RequestMapping("/packing")
@Validated
public class PackingController {

    @Autowired
    PackingLibraryService packingLibraryService;

    @Autowired
    TaskService taskService;

    @Autowired
    UserUtils userUtils;

    @Autowired
    UserPublicService userPublicService;

    @Autowired
    TaskLogService taskLogService;

    @Autowired
    MyWebSocket myWebSocket;

    @Autowired
    PackingLibraryDao packingLibraryDao;

    @Autowired
    DeviceLibraryService deviceLibraryService;

    @Autowired
    MessageService messageService;

    @Autowired
    PackingLogDao packingLogDao;

    @Autowired
    PackingLogService packingLogService;

    @Autowired
    ConfigCache configCache;

    @ApiOperation(value = "查询列装详情", notes = "可以通过这个接口查询列装详情")
    @GetMapping(value = "/detail/{billId}")
    public ResponseEntity selectDetail(@PathVariable("billId") @Min(value = 1,message = "billId不能小于1") int billId) {
        PackingDetailVo packingDetailVo = new PackingDetailVo();
        //获取taskBto
        TaskBto taskBto = taskService.get(billId, BusinessEnum.PACKING.id);
        //获取列装主件
        PackingLibrary packingLibraryEntity = packingLibraryService.getOne(billId);
        packingLibraryEntity.setUserA(userPublicService.getOne(packingLibraryEntity.getUseraId()).getName());
        packingLibraryEntity.setUserB(userPublicService.getOne(packingLibraryEntity.getUserbId()).getName());
        packingDetailVo.setPackingLibrary(packingLibraryEntity.setConfigName());
        //获取所有配件
        List<PackingLibrary> packingLibraryEntities = packingLibraryService.selectAllPart(billId);
        packingDetailVo.setParts(packingLibraryEntities);
        //获取业务日志
        List<TaskLogUserVo> taskLogUserVos = taskLogService.getByTaskId(taskBto.getId());
        packingDetailVo.setTaskLogUserVos(taskLogUserVos);
        return ResultUtil.success(packingDetailVo);
    }

    @ApiOperation(value = "添加列装型号")
    @PostMapping("/add/model")
    public ResponseEntity addModel(@RequestBody @Validated AddModel addModel){
        if (packingLibraryService.modelIsExist(addModel.getModel())){
            Map<String,Object> map = new HashMap<>();
            map.put("error","型号"+addModel.getModel()+"已存在");
            return ResponseEntity.ok(map);
        }
        PackingLibrary packingLibrary = new PackingLibrary();
        BeanUtils.copyProperties(addModel,packingLibrary);
        packingLibrary.setIsRoot(1);
        packingLibrary.setName(addModel.getModel());
        packingLibrary.setPackingStatus(2);
        packingLibrary.setShowOrder(99999);
        PackingLibrary packingLibrary1 = packingLibraryService.addEntity(packingLibrary);
        List<PackingLibrary> packingLibraries1 = packingLibraryService.getInsertList(new SelectPack()).stream().sorted(Comparator.comparing(PackingLibrary::getModel,Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
        int order = 9999;
        for (int i=1;i<=packingLibraries1.size();i++){
            PackingLibrary packingLibrary2 = packingLibraries1.get(i-1);
            if (packingLibrary2.getId().equals(packingLibrary1.getId())){
                packingLibrary2.setShowOrder(i);
                packingLibraryService.update(packingLibrary2);
                order = i;
                break;
            }
        }
        for (PackingLibrary p:packingLibraries1) {
            if (!p.getId().equals(packingLibrary1.getId()) && p.getShowOrder() >= order){
                p.setShowOrder(p.getShowOrder()+1);
                packingLibraryService.update(p);
            }
        }
//        TaskBto taskBto = new TaskBto(StatusEnum.END.id, "列装业务", null, ".", packingLibrary1.getId(), 1, userUtils.getCurrentUnitId(), 0, null, Collections.singletonList(userUtils.getCurrentUserId()));
//        TaskBto saveEntity = taskService.start(taskBto);
        String message = "添加列装型号:"+addModel.getModel();
//        //添加业务日志
//        TaskLogBto taskLogBto2 = new TaskLogBto(saveEntity.getId(), message, null);
//        taskLogService.addLog(taskLogBto2);
        //添加列装日志
        PackingLog packingLog = new PackingLog();
        packingLog.setRemark(message);
        packingLog.setPackingId(packingLibrary1.getId());
        packingLogService.add(packingLog);
        //发送阅知信息
        List<Integer> userIds = userPublicService.findOtherUser(userUtils.getCurrentUserId());
        MessageBto messageBto = new MessageBto(0,1,message,userIds,0);
        messageBto.setRecord(packingLibrary1.getId().toString());
        messageService.add(messageBto);
        return ResponseEntity.ok(packingLibrary1);
    }

    @ApiOperation(value = "添加列装装备")
    @PostMapping("/add")
    public ResponseEntity addPack(@RequestBody @Validated AddPack addPack){
        if (packingLibraryService.nameIsExist(addPack.getModel(),addPack.getName())){
            Map<String,Object> map = new HashMap<>();
            map.put("error","型号"+addPack.getModel()+"下名称为"+addPack.getName()+"的装备已存在");
            return ResponseEntity.ok(map);
        }
        if (packingLibraryService.matchingRangeIsExist(addPack.getPartParentId(),addPack.getMatchingRange())){
            Map<String,Object> map = new HashMap<>();
            map.put("error","型号"+addPack.getModel()+"下配用范围为"+configCache.getMatchingRangeMap().get(addPack.getMatchingRange())+"的装备已存在");
            return ResponseEntity.ok(map);
        }
        PackingLibrary packingLibrary = addPack.toDo();
        PackingLibrary packingLibrary1 = packingLibraryService.getOne(addPack.getPartParentId());
//        TaskBto taskBto = new TaskBto(StatusEnum.END.id, "列装业务", null, ".", packingLibrary1.getId(), 1, userUtils.getCurrentUnitId(), 0, null, Collections.singletonList(userUtils.getCurrentUserId()));
//        TaskBto saveEntity = taskService.start(taskBto);
        if (packingLibrary1.getIsRoot()==1){
            packingLibrary.setIsPart(0);
            String message = "添加列装装备:"+addPack.getName();
//            //添加业务日志
//            TaskLogBto taskLogBto2 = new TaskLogBto(saveEntity.getId(), message, null);
//            taskLogService.addLog(taskLogBto2);
            //发送阅知信息
            List<Integer> userIds = userPublicService.findOtherUser(userUtils.getCurrentUserId());
            MessageBto messageBto = new MessageBto(0,1,message,userIds,0);
            messageBto.setRecord(packingLibrary1.getId().toString());
            messageService.add(messageBto);
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark(message);
            packingLog.setPackingId(packingLibrary1.getId());
            packingLogService.add(packingLog);
        }
        else {
            packingLibrary.setIsPart(1);
            String message = "添加列装装备附件:"+addPack.getName();
//            //添加业务日志
//            TaskLogBto taskLogBto2 = new TaskLogBto(saveEntity.getId(), message, null);
//            taskLogService.addLog(taskLogBto2);
            //发送阅知信息
            List<Integer> userIds = userPublicService.findOtherUser(userUtils.getCurrentUserId());
            MessageBto messageBto = new MessageBto(0,1,message,userIds,0);
            messageBto.setRecord(packingLibrary1.getId().toString());
            messageService.add(messageBto);
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark(message);
            packingLog.setPackingId(packingLibrary1.getId());
            packingLogService.add(packingLog);
        }
        PackingLibrary packingLibrary2 = packingLibraryService.addEntity(packingLibrary);
        //添加列装日志
        PackingLog packingLog = new PackingLog();
        packingLog.setRemark("添加列装");
        packingLog.setPackingId(packingLibrary2.getId());
        packingLogService.add(packingLog);
        return ResponseEntity.ok("添加成功");
    }

    @ApiOperation(value = "删除列装")
    @PostMapping("/delete/{id}")
    public ResponseEntity deleteById(@PathVariable("id") int id){
        packingLibraryService.deleteAll(id);
        return ResponseEntity.ok("删除成功");
    }

    @ApiOperation(value = "退装恢复列装")
    @PostMapping("/remove")
    public ResponseEntity remove(@RequestBody List<Integer> ids){
        packingLibraryService.removeAll(ids);
        return ResponseEntity.ok("恢复成功");
    }

    @ApiOperation(value = "查询父子结构列装")
    @PostMapping("/select")
    public ResponseEntity selectPack(@RequestBody SelectPack selectPack){
        if (selectPack.getContent()==null&&selectPack.getModel()==null&&selectPack.getName()==null&&selectPack.getSecretLevel()==null&&selectPack.getStatus()==null){
            return ResultUtil.success(PageUtil.getPerPage(selectPack.getPage(), selectPack.getSize(), packingLibraryService.setOrder(packingLibraryService.getInsertList(selectPack)), selectPack.getPageable()));
        }
        else {
            return ResultUtil.success(PageUtil.getPerPage(selectPack.getPage(), selectPack.getSize(), packingLibraryService.getInsertList(selectPack), selectPack.getPageable()));
        }
    }

    @ApiOperation(value = "根据型号查询所有装备附件")
    @PostMapping("/selectByModel")
    public ResponseEntity selectByModel(@RequestBody PackingLibrarySelectVo packingLibrarySelectVo){
        List<PackingLibrary> packingLibraryEntities = packingLibraryService.getList(packingLibrarySelectVo);
        return ResponseEntity.ok(packingLibraryService.setAllotNum(packingLibraryEntities));
    }

    @ApiOperation(value = "根据型号查询所有装备附件")
    @PostMapping("/getAllotSeqs/{num}")
    public ResponseEntity getAllotSeqs(@RequestBody List<Integer> ids,@PathVariable("num") int num){
        List<String> strings = new ArrayList<>();
        List<List<Integer>> deviceIds = new ArrayList<>();
        List<Integer> devIds = new ArrayList<>();
        AllotSeqs allotSeqs1 = new AllotSeqs();
        ids.forEach(integer -> {
            AllotSeqs allotSeqs = packingLibraryService.getAllotAutoSeqs(integer,num);
            strings.add(allotSeqs.getStrings().get(0));
            deviceIds.add(allotSeqs.getIds());
            devIds.addAll(allotSeqs.getIds());
        });
        allotSeqs1.setIdLists(deviceIds);
        allotSeqs1.setIds(devIds);
        allotSeqs1.setStrings(strings);
        return ResponseEntity.ok(allotSeqs1);
    }

    @ApiOperation(value = "配发设置区间")
    @PostMapping("/setAllotSeqs/{id}/{num}/{seq}")
    public ResponseEntity setAllotSeqs(@PathVariable("id") int id,@PathVariable("num") int num,@PathVariable("seq") String seq){
        List<DeviceLibrary> deviceLibraries = packingLibraryService.getAllDevSeqs(id);
        List<String> existSeqs = deviceLibraries.stream().map(DeviceLibrary::getSeqNumber).collect(Collectors.toList());
        List<String> inputSeqs = DeviceSeqUtil.selectDeviceSeqs(seq);
        if (existSeqs.containsAll(inputSeqs)){
            if (inputSeqs.size()!=num){
                return ResponseEntity.ok("序列号区间装备数量为"+inputSeqs.size()+"，与填写数量不符");
            }
            else {
                List<Integer> ids = deviceLibraries.stream().filter(deviceLibrary -> inputSeqs.contains(deviceLibrary.getSeqNumber())).map(DeviceLibrary::getId).collect(Collectors.toList());
                return ResponseEntity.ok(ids);
            }
        }
        else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("序列号");
            inputSeqs.removeAll(existSeqs);
            inputSeqs.forEach(s -> stringBuffer.append(s).append(","));
            stringBuffer.deleteCharAt(stringBuffer.length()-1);
            stringBuffer.append("不存在");
            return ResponseEntity.ok(stringBuffer.toString());
        }
    }

    @ApiOperation(value = "判断序列号区间是否存在")
    @PostMapping("/seqsExist/{id}/{num}/{seq}")
    public ResponseEntity seqsExist(@PathVariable("id") int id,@PathVariable("num") int num,@PathVariable("seq") String seq){
        List<DeviceLibrary> deviceLibraries = packingLibraryService.getAllDevSeqs(id);
        List<String> existSeqs = deviceLibraries.stream().map(DeviceLibrary::getSeqNumber).collect(Collectors.toList());
        List<String> inputSeqs = DeviceSeqUtil.selectDeviceSeqs(seq);
        if (inputSeqs.size()!=num){
            return ResponseEntity.ok("序列号区间总数为"+inputSeqs.size()+",与装备数量不匹配");
        }
        else {
            if (existSeqs.containsAll(inputSeqs)){
                return ResponseEntity.ok("ok");
            }
            else {
                existSeqs.retainAll(inputSeqs);
                inputSeqs.removeAll(existSeqs);
                StringBuffer stringBuffer = new StringBuffer();
                inputSeqs.forEach(s -> stringBuffer.append(s).append(","));
                stringBuffer.deleteCharAt(stringBuffer.length()-1);
                return ResponseEntity.ok("该型号序列号为"+stringBuffer.toString()+"的装备不存在");
            }
        }
    }

    @ApiOperation(value = "编辑列装型号")
    @PostMapping("/update/model")
    public ResponseEntity updateModel(@RequestBody @Validated PackingModelEdit packingModelEdit){
        PackingLibrary packingLibrary = packingLibraryService.getOne(packingModelEdit.getPackingId());
        List<PackingLibrary> packingLibraries = new ArrayList<>();
        if (packingLibrary.getShowOrder()>packingModelEdit.getShowOrder()){
            for (int i = packingModelEdit.getShowOrder();i<packingLibrary.getShowOrder();i++){
                if (packingLibraryDao.findByShowOrder(i)!=null){
                    PackingLibrary packingLibrary1 = packingLibraryDao.findByShowOrder(i);
                    packingLibrary1.setShowOrder(i+1);
                    packingLibraries.add(packingLibrary1);
                }
                else {
                    break;
                }
            }
        }
        else if(packingLibrary.getShowOrder()<packingModelEdit.getShowOrder()){
            for (int i = packingLibrary.getShowOrder()+1;i<=packingModelEdit.getShowOrder();i++){
                if (packingLibraryDao.findByShowOrder(i)!=null){
                    PackingLibrary packingLibrary1 = packingLibraryDao.findByShowOrder(i);
                    packingLibrary1.setShowOrder(i-1);
                    packingLibraries.add(packingLibrary1);
                }
                else {
                    break;
                }
            }
        }
        else{
            packingLibrary.setShowOrder(packingLibrary.getShowOrder());
        }
        if (packingLibraries.size()>0) {
            packingLibraryDao.saveAll(packingLibraries);
        }
        if (packingLibrary.getIsRoot()==1){
            if (!packingLibrary.getModel().equals(packingModelEdit.getModel())&&packingLibraryService.modelIsExist(packingModelEdit.getModel())){
                Map<String,Object> map = new HashMap<>();
                map.put("error","型号"+packingModelEdit.getModel()+"已存在");
                return ResponseEntity.ok(map);
            }
            BeanUtils.copyProperties(packingModelEdit,packingLibrary);
            if (packingModelEdit.getModel()!=null){
                packingLibrary.setName(packingModelEdit.getModel());
                packingLibraryService.changeAllModel(packingLibrary.getId(),packingModelEdit.getModel());
            }
            packingLibraryService.update(packingLibrary);
            //发送阅知信息
            List<Integer> userIds = userPublicService.findOtherUser(userUtils.getCurrentUserId());
            MessageBto messageBto = new MessageBto(0,1,"修改列装型号目录",userIds,0);
            messageService.add(messageBto);
        }
        else {
            throw new ApiException("传入的列装id不是型号");
        }
        return ResponseEntity.ok("编辑成功");
    }

    @ApiOperation(value = "编辑列装装备")
    @PostMapping("/update/device")
    public ResponseEntity updateDevice(@RequestBody @Validated PackingLibraryUpdateVo packingLibraryUpdateVo){
        PackingLibrary packingLibrary = packingLibraryService.getOne(packingLibraryUpdateVo.getPackingId());
        //复制相同的字段
        if (packingLibraryUpdateVo.getName()!=null&&!packingLibraryUpdateVo.getName().equals(packingLibrary.getName())&&!packingLibraryService.nameIsExist(packingLibrary.getModel(),packingLibraryUpdateVo.getName())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将名称从"+packingLibrary.getName()+"改为"+packingLibraryUpdateVo.getName());
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setName(packingLibraryUpdateVo.getName());
        }
        if (packingLibraryUpdateVo.getApplyType()!=null&&!packingLibraryUpdateVo.getApplyType().equals(packingLibrary.getApplyType())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将应用类型从"+configCache.getApplyTypeMap().get(packingLibrary.getApplyType())+"改为"+configCache.getApplyTypeMap().get(packingLibraryUpdateVo.getApplyType()));
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setApplyType(packingLibraryUpdateVo.getApplyType());
        }
        if (packingLibraryUpdateVo.getSecretLevel()!=null&&!packingLibraryUpdateVo.getSecretLevel().equals(packingLibrary.getSecretLevel())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将密级从"+configCache.getSecretLevelMap().get(packingLibrary.getSecretLevel())+"改为"+configCache.getSecretLevelMap().get(packingLibraryUpdateVo.getSecretLevel()));
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setSecretLevel(packingLibraryUpdateVo.getSecretLevel());
        }
        if (packingLibraryUpdateVo.getMatchingRange()!=null&&!packingLibraryUpdateVo.getMatchingRange().equals(packingLibrary.getMatchingRange())&&!packingLibraryService.matchingRangeIsExist(packingLibrary.getPartParentId(),packingLibraryUpdateVo.getMatchingRange())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将配用范围从"+configCache.getMatchingRangeMap().get(packingLibrary.getMatchingRange())+"改为"+configCache.getMatchingRangeMap().get(packingLibraryUpdateVo.getMatchingRange()));
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setMatchingRange(packingLibraryUpdateVo.getMatchingRange());
        }
        if (packingLibraryUpdateVo.getInvisibleRange()!=null&&!packingLibraryUpdateVo.getInvisibleRange().equals(packingLibrary.getInvisibleRange())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将可见范围从"+configCache.getInvisibleRangeMap().get(packingLibrary.getInvisibleRange())+"改为"+configCache.getInvisibleRangeMap().get(packingLibraryUpdateVo.getInvisibleRange()));
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setInvisibleRange(packingLibraryUpdateVo.getInvisibleRange());
        }
        if (packingLibraryUpdateVo.getType()!=null&&!packingLibraryUpdateVo.getType().equals(packingLibrary.getType())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将形态从"+configCache.getStyleMap().get(packingLibrary.getType())+"改为"+configCache.getStyleMap().get(packingLibraryUpdateVo.getType()));
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setType(packingLibraryUpdateVo.getType());
        }
        if (packingLibraryUpdateVo.getStyle()!=null&&!packingLibraryUpdateVo.getStyle().equals(packingLibrary.getStyle())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            String s1= packingLibrary.getStyle()==1?"装备":"附件";
            String s2= packingLibraryUpdateVo.getStyle()==1?"装备":"附件";
            packingLog.setRemark("将类型从"+s1+"改为"+s2);
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setStyle(packingLibraryUpdateVo.getStyle());
        }
        if (packingLibraryUpdateVo.getProdUnit()!=null&&!packingLibraryUpdateVo.getProdUnit().equals(packingLibrary.getProdUnit())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将生产单位从"+packingLibrary.getProdUnit()+"改为"+packingLibraryUpdateVo.getProdUnit());
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setProdUnit(packingLibraryUpdateVo.getProdUnit());
        }
        if (packingLibraryUpdateVo.getPrice()!=null&&!packingLibraryUpdateVo.getPrice().equals(packingLibrary.getPrice())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("将价格从"+packingLibrary.getPrice()+"改为"+packingLibraryUpdateVo.getPrice());
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setPrice(packingLibraryUpdateVo.getPrice());
        }
        if (packingLibraryUpdateVo.getImageUrl()!=null&&!packingLibraryUpdateVo.getImageUrl().equals(packingLibrary.getImageUrl())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("更新设备图片");
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setImageUrl(packingLibraryUpdateVo.getImageUrl());
            packingLibrary.setImageName(packingLibraryUpdateVo.getImageName());
        }
        if (packingLibraryUpdateVo.getFileUrl()!=null&&!packingLibraryUpdateVo.getFileUrl().equals(packingLibrary.getFileUrl())){
            //添加列装日志
            PackingLog packingLog = new PackingLog();
            packingLog.setRemark("更新列装文件");
            packingLog.setPackingId(packingLibrary.getId());
            packingLogService.add(packingLog);
            packingLibrary.setFileUrl(packingLibraryUpdateVo.getFileUrl());
            packingLibrary.setFileName(packingLibraryUpdateVo.getFileName());
        }
        packingLibraryService.update(packingLibrary);
        //发送阅知信息
        List<Integer> userIds = userPublicService.findOtherUser(userUtils.getCurrentUserId());
        MessageBto messageBto = new MessageBto(0,1,"修改列装装备信息",userIds,0);
        messageService.add(messageBto);
        return ResponseEntity.ok("编辑成功");
    }

    @ApiOperation(value = "获取列装名称")
    @GetMapping("/getName/{id}")
    public ResponseEntity getPackName(@PathVariable("id") int id){
        PackingLibrary packingLibrary = packingLibraryService.getOne(id);
        return ResponseEntity.ok(packingLibrary.getName());
    }

    @ApiOperation(value = "获取列装日志")
    @GetMapping("/getLogs/{id}")
    public ResponseEntity getPackingLogs(@PathVariable("id") int id){
        List<DeviceLogUserVo> deviceLogUserVos = packingLogDao.getAllByPackingId(id).stream().map(PackingLog::toVo).sorted(Comparator.comparing(DeviceLogUserVo::getCreateTime).reversed()).collect(Collectors.toList());
        return ResponseEntity.ok(deviceLogUserVos);
    }

    @ApiOperation(value = "撤销列装装备")
    @PostMapping("/concle")
    public ResponseEntity concle(@RequestBody ConcleVo concleVo){
        List<PackingLibrary> packingLibraries = concleVo.getPackingLibraries();
        packingLibraries.add(concleVo.getPackingLibrary1());
        //返回父子结构
        Map<Integer, PackingLibrary> nodeCollect =
                packingLibraries.stream().collect(Collectors.toMap(PackingLibrary::getId, packingLibrary -> packingLibrary));
        return ResponseEntity.ok(GetTreeUtils.parseTreeFromDown(
                packingLibraries,
                PackingLibrary::getId,
                packingLibrary -> Optional.ofNullable(nodeCollect.get(packingLibrary.getPartParentId())),
                PackingLibrary::addChildNode
        ));
    }
}
