package com.tykj.dev.device.packing.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Repository
@Data
@ApiModel("列装编辑类")
public class PackingEditVo {

    @ApiModelProperty(value = "列装库更新信息")
    private PackingLibraryUpdateVo updateVoList;

    @ApiModelProperty(value = "列装库配件更新信息")
    private List<PackingLibraryUpdateVo> partUpdateVoList;

    @ApiModelProperty(value = "新增配件信息列表")
    private List<PartSaveVo> partAddList;

    @ApiModelProperty(value = "删除相关配件id")
    private List<Integer> partIdDeleteList;

    @ApiModelProperty(value = "列装装备id", example = "1")
    @NotNull(message = "packingId不能为空")
    private Integer packingId;
}
