package com.tykj.dev.device.repair.repository;

import com.tykj.dev.device.repair.subject.domin.RepairDetail;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

public interface RepairDetailDao extends JpaRepository<RepairDetail, Integer>, JpaSpecificationExecutor<RepairDetail> {
    List<RepairDetail> findByDeviceRepairBillId(Integer billId);
    List<RepairDetail> findByRepairBackBillId(Integer billId);
    List<RepairDetail> findAllByRepairStatusAndOwnUnit(Integer repairStatus,String ownUnit);
    List<RepairDetail> findAllByRepairStatusIn(List<Integer> repairStatus, Sort s);
    List<RepairDetail> findAllByRepairStatusNotIn(List<Integer> repairStatus, Sort s);
    List<RepairDetail> findAllByRepairStatus(Integer repairStatus);
    List<RepairDetail> findAllByRepairStatus(Integer repairStatus, Sort s);
    List<RepairDetail> findAllByDeviceId(Integer deviceId);
}
