package com.tykj.dev.device.repair.service;


import com.tykj.dev.device.repair.subject.domin.RepairDetail;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepairDetailService.java
 * @Description TODO
 * @createTime 2020年08月25日 10:33:00
 */
public interface RepairDetailService extends RepairPublicService<RepairDetail> {

    /**
     * 根据billid查询维修单的设备
     *
     * @param billId 维修单id
     * @return 所对应的装备信息
     */
    List<RepairDetail> findByBillId(Integer billId);


    /**
     * 修改业务对应装备的状态
     *
     * @param id     对应装备的id
     * @param status 修改的状态
     * @return 修改的对装备对象
     */
    RepairDetail updateIdAndStatus(Integer id, Integer status);

    /**
     * @param id 主键id
     *           根据主键Id查询
     */
    RepairDetail getOne(Integer id);

    /**
     * @param repairDetails 异步上链
     */
    void sendHash(List<RepairDetail> repairDetails);

}
