package com.tykj.dev.device.repair.service.impl;

import com.tykj.dev.blockcha.subject.entity.BcHash;
import com.tykj.dev.blockcha.subject.service.BlockChainUtil;
import com.tykj.dev.config.TaskBeanConfig;
import com.tykj.dev.device.repair.repository.RepairDetailDao;
import com.tykj.dev.device.repair.service.RepairDetailService;
import com.tykj.dev.device.repair.subject.domin.RepairDetail;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.ResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepairDetailServiceImpl.java
 * @Description TODO
 * @createTime 2020年08月25日 10:37:00
 */
@Service
public class RepairDetailServiceImpl implements RepairDetailService {
    @Autowired
    RepairDetailDao deviceRepairDetailDao;

    @Autowired
    private BlockChainUtil blockChainUtil;

    @Override
    public RepairDetail save(RepairDetail deviceRepairDetailEntity) {
        RepairDetail repairDetail = deviceRepairDetailDao.save(deviceRepairDetailEntity);
        CompletableFuture.runAsync(()->{
            RepairDetail repairDetail1 = getOne(repairDetail.getId());
            BcHash bcText = blockChainUtil.sendHash(1000, JacksonUtil.toJSon(repairDetail1));
            String recordId = bcText.getData().getRecordID();
            repairDetail1.setRecordId(recordId);
            deviceRepairDetailDao.save(repairDetail1);
        }, TaskBeanConfig.getThreadPoolTaskScheduler());
        return repairDetail;
    }

    @Override
    public boolean delete(Integer id) {
        return false;
    }

    @Override
    public List<RepairDetail> findAll() {
        return deviceRepairDetailDao.findAll();
    }

    @Override
    public RepairDetail update(RepairDetail deviceRepairDetailEntity) {
        RepairDetail repairDetail = deviceRepairDetailDao.save(deviceRepairDetailEntity);
        CompletableFuture.runAsync(()-> blockChainUtil.appendHash(JacksonUtil.toJSon(repairDetail),repairDetail.getRecordId()), TaskBeanConfig.getThreadPoolTaskScheduler());
        return repairDetail;
    }

    @Override
    public List<RepairDetail> findByBillId(Integer billId) {
        List<RepairDetail> repairDetails = deviceRepairDetailDao.findByDeviceRepairBillId(billId);
        repairDetails.forEach(RepairDetail::setConfigName);
        return repairDetails;
    }

    @Override
    public RepairDetail updateIdAndStatus(Integer id, Integer status) {
        Optional<RepairDetail> repairDetail = deviceRepairDetailDao.findById(id);
        if (repairDetail.isPresent()) {
            RepairDetail repairDetail1 = repairDetail.get();
            repairDetail1.setRepairStatus(status);
            deviceRepairDetailDao.save(repairDetail1);
            return repairDetail1;
        } else {
            throw new ApiException(ResultUtil.failed("所查询ID不存在"));
        }
    }

    /**
     * @param id 主键id
     *           根据主键Id查询
     */
    @Override
    public RepairDetail getOne(Integer id) {
        Optional<RepairDetail> repairDetail = deviceRepairDetailDao.findById(id);
        if (repairDetail.isPresent()) {
            return repairDetail.get().setConfigName();
        } else {
            throw new ApiException(ResultUtil.failed("所查询ID不存在"));
        }
    }

    /**
     * @param repairDetails 异步上链
     */
    @Override
    @Async
    public void sendHash(List<RepairDetail> repairDetails) {
        repairDetails.forEach(repairDetail -> {
            BcHash bcText = blockChainUtil.sendHash(1000, JacksonUtil.toJSon(repairDetail));
            String recordId = bcText.getData().getRecordID();
            repairDetail.setRecordId(recordId);
            update(repairDetail);
        });
    }
}
