package com.tykj.dev.device.repair.subject.domin;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for repair_back_bill
 * 装备维修完成退回账单
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update repair_back_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备维修完成退回账单")
public class RepairBackBill {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 维修退回标题
     */
    @ApiModelProperty(value = "维修退回标题")
    private String title;
    /**
     * 申请文号
     */
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;
    /**
     * 批复文号
     */
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    /**
     * 发件单位
     */
    @ApiModelProperty(value = "发件单位")
    private String sendUnit;
    /**
     * 收件单位
     */
    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;
    /**
     * 配发时间
     */
    @ApiModelProperty(value = "配发时间")
    private Date sendTime;
    /**
     * 接收时间
     */
    @ApiModelProperty(value = "接收时间")
    private Date receiveTime;
    /**
     * 维修单id
     */
    @ApiModelProperty(value = "维修单id")
    private Integer deviceRepairBillId;
    /**
     * 维修完成退回经办人id(省A岗)
     */
    @ApiModelProperty(value = "维修完成退回经办人id(省A岗)")
    private Integer startUseraId;
    /**
     * 维修完成退回审核人id(省B岗)
     */
    @ApiModelProperty(value = "维修完成退回审核人id(省B岗)")
    private Integer startUserbId;
    /**
     * 维修完成接收单位经办人id(市A岗)
     */
    @ApiModelProperty(value = "维修完成接收单位经办人id(市A岗)")
    private Integer receiveUseraId;
    /**
     * 维修完成接收单位审核人id(市B岗)
     */
    @ApiModelProperty(value = "维修完成接收单位审核人id(市B岗)")
    private Integer receiveUserbId;
    /**
     * 出库附件文件名
     */
    @ApiModelProperty(value = "出库附件文件名")
    private String fileName;
    /**
     * 出库附件文件地址URL
     */
    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "出库附件文件地址URL")
    private String fileUrl;
    /**
     * 入库附件文件名
     */
    @ApiModelProperty(value = "入库附件文件名")
    private String receiveFileName;
    /**
     * 入库附件文件地址URL
     */
    @Column(name = "receive_file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "入库附件文件地址URL")
    private String receiveFileUrl;
    /**
     * 账单文件名
     */
    @ApiModelProperty(value = "账单文件名")
    private String billFileName;
    /**
     * 账单文件地址URL
     */
    @Column(name = "bill_file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "账单文件地址URL")
    private String billFileUrl;
    /**
     * 应出库装备数量
     */
    @ApiModelProperty(value = "应出库装备数量")
    private Integer sendingCount;
    /**
     * 已出库装备数量
     */
    @ApiModelProperty(value = "已出库装备数量")
    private Integer sendedCount;
    /**
     * 已接收装备数量
     */
    @ApiModelProperty(value = "已接收装备数量")
    private Integer receiveCount;
    /**
     * 退回状态(1:维修成功出库待审核,2:维修成功出库审核失败,3:重新配发出库待审核,4:重新配发出库审核失败,5:退回中,5:送修方接收待审核,6:送修方接收审核失败,7:维修退回完成)
     */
    @ApiModelProperty(value = "退回状态(1:维修成功出库待审核,2:维修成功出库审核失败,3:重新配发出库待审核,4:重新配发出库审核失败,5:退回中,5:送修方接收待审核,6:送修方接收审核失败,7:维修退回完成)")
    private Integer backStatus;
    /**
     * 维修完成出库详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @Column(name = "back_check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "维修完成出库详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String backCheckDetail;
    /**
     * 维修完成出库检查结果
     */
    @ApiModelProperty(value = "维修完成出库检查结果")
    private String backCheckResult;
    /**
     * 维修完成接收入库详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @Column(name = "back_recive_check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "维修完成接收入库详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String backReciveCheckDetail;
    /**
     * 维修完成接收入库检查结果
     */
    @ApiModelProperty(value = "维修完成接收入库检查结果")
    private String backReciveCheckResult;
    /**
     * 创建用户id
     */
    @CreatedBy
    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy
    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;
    /**
     * 签发人
     */
    @ApiModelProperty(value = "签发人")
    private String agent;
    /**
     * 维修回执单档案号
     */
    @ApiModelProperty(value = "维修单档案号")
    private String docNum;

    @ApiModelProperty(value = "发起人")
    @Transient
    private String startUserA;

    @ApiModelProperty(value = "发起确认人")
    @Transient
    private String startUserB;

    @ApiModelProperty(value = "接收人")
    @Transient
    private String receiveUserA;

    @ApiModelProperty(value = "接收确认人")
    @Transient
    private String receiveUserB;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @Column(name = "send_files",columnDefinition = "TEXT")
    private String sendFiles;

    @Column(name = "receive_files",columnDefinition = "TEXT")
    private String receiveFiles;

    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @Transient
    private List<ScriptSaveVo> scripts = new ArrayList<>();

    @Transient
    private List<FileRet> sendFileList = new ArrayList<>();

    @Transient
    private List<FileRet> receiveFileList = new ArrayList<>();
}
