package com.tykj.dev.device.repair.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for repair_bill
 * 装备维修账单
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update repair_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备维修账单")
public class RepairBill {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 申请文号
     */
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;
    /**
     * 批复文号
     */
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    /**
     * 申请单位
     */
    @ApiModelProperty(value = "申请单位")
    private String sendUnit;
    /**
     * 维修单位
     */
    @ApiModelProperty(value = "维修单位")
    private String receiveUnit;
    /**
     * 维修状态
     */
    @ApiModelProperty(value = "维修状态")
    private Integer repairStatus;
    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    /**
     * 申请人
     */
    @ApiModelProperty(value = "申请人")
    private String startUserA;

    /**
     * 申请确认人
     */
    @ApiModelProperty(value = "申请确认人")
    private String startUserB;

    /**
     * 维修经手人
     */
    @ApiModelProperty(value = "维修经手人")
    private String repairUserA;

    /**
     * 维修核验人
     */
    @ApiModelProperty(value = "维修核验人")
    private String repairUserB;

    /**
     * 维修单档案号
     */
    @ApiModelProperty(value = "维修单档案号")
    private String docNum;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;
}
