package com.tykj.dev.device.repair.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("维修装备换新类")
public class ChangeNewDeviceVo {

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(name = "业务id", value = "1")
    private Integer taskId;

    @NotNull(message = "id不能为空")
    @Min(value = 1,message = "id不能小于1")
    @ApiModelProperty(name = "维修详情单主键Id", value = "1")
    private Integer id;

    @NotNull(message = "deviceId不能为空")
    @Min(value = 1,message = "deviceId不能小于1")
    @ApiModelProperty(name = "装备主键id", value = "1")
    private Integer deviceId;

    @NotNull(message = "type不能为空")
    @Min(value = 0,message = "type不能小于0")
    @ApiModelProperty(name = "换新类型", value = "0:库存换新（不继承日志），1:新装备换新（继承日志）")
    private Integer type;
}
