package com.tykj.dev.device.repair.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("上传领取单据类")
public class FileVo {

    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务Id")
    private Integer taskId;

    @ApiModelProperty(value = "领取单附件")
    private List<FileRet> sendFiles;

//    @NotNull(message = "status不能为空")
    @ApiModelProperty(value = "是否上传单据（0：否，1：是）")
    private Integer status;

    @ApiModelProperty(value = "接收单位A岗")
    private Integer receiveUseraId;

    @ApiModelProperty(value = "接收单位B岗")
    private Integer receiveUserbId;
}
