package com.tykj.dev.device.repair.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("业务备注类")
public class TaskRemark {

    @Min(value = 1,message = "id不能小于1")
    @ApiModelProperty(value = "任务ID", example = "1")
    private Integer id;

    @NotNull
    @ApiModelProperty(value = "备注")
    private String remark;
}
