package com.tykj.dev.device.retired.entity.domain;

import com.tykj.dev.device.retired.entity.enums.RetiredStatus;
import com.tykj.dev.device.retired.entity.vo.DeviceRetiredFormVo;
import com.tykj.dev.device.user.subject.entity.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * entity class for device_retired_bill
 * 退装账单
 *
 * @author admin
 */
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_retired_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("退装账单")
public class DeviceRetiredBill {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 省A岗id
     */
    @ApiModelProperty(value = "省A岗id")
    private Integer userAId;
    /**
     * 省B岗id
     */
    @ApiModelProperty(value = "省B岗id")
    private Integer userBId;
    /**
     * 退装状态(0:待审核,1:审核失败,2:退装成功)
     */
    @ApiModelProperty(value = "退装状态(0:待审核,1:审核失败,2:退装成功)")
    private Integer retiredStatus;
    /**
     * 列装库主键id(x作为分隔符)，例如1x2,意为列装库id为1和2的退装
     */
    @Column(name = "retired_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "列装库主键id(x作为分隔符)，例如x1x2,意为列装库id为1和2的退装")
    private String retiredDetail;
    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    public DeviceRetiredBill(Integer userAId, Integer userBId, Integer retiredStatus, String retiredDetail) {
        this.userAId = userAId;
        this.userBId = userBId;
        this.retiredStatus = retiredStatus;
        this.retiredDetail = retiredDetail;
    }

    public static DeviceRetiredBill formVoToBill(DeviceRetiredFormVo formVo, User user) {
        return new DeviceRetiredBill(
                user.getUserId(),
                formVo.getConfirmUserId(),
                RetiredStatus.CONFIRM_SUCCESS.getStatus(),
                packingListToString(formVo.getPackings())
        );
    }

    /**
     * 生成装备销毁出库详情,并为对应的装备生成变更日志
     *
     * @return 装备出库详情
     */
    private static String packingListToString(List<Integer> packings) {
        StringBuffer deviceDetail = new StringBuffer();
        deviceDetail.append("x");
        packings.forEach(packing -> {
            deviceDetail.append(packing.toString());
            deviceDetail.append(1);
            deviceDetail.append("x");
        });
        return deviceDetail.toString();
    }
}
