package com.tykj.dev.device.retired.entity.vo;

import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class DeviceDestoryDetailSelectVo
 * @packageName com.tykj.dev.device.destory.subject.entity.vo
 **/
@Data
@ApiModel("销毁详情查询类")
public class DeviceRetiredDetailResultVo {

    @ApiModelProperty(value = "发起人id", example = "1")
    private Integer startUserId;

    @ApiModelProperty(value = "审核人id", example = "1")
    private Integer confirmUserId;

    @ApiModelProperty(value = "发起人", example = "1")
    private String startUser;

    @ApiModelProperty(value = "审核人", example = "1")
    private String confirmUser;

    @ApiModelProperty(value = "销毁状态(0:销毁装备出库待审核,1:销毁装备出库审核失败,2:已销毁)")
    private Integer retiredStatus;

    @ApiModelProperty(value = "销毁装备列表", example = "1")
    private List<PackingLibrary> packingLibrarys = new ArrayList<>();
}
