package com.tykj.dev.rfid.entity.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @author dengdiyi
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("单位对应门禁名称")
public class AccessControlName {
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(value = "门禁名称")
    private String deviceNo;

    @ApiModelProperty(value = "所属单位")
    private Integer unitId;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;
}
