package com.tykj.dev.rfid.entity.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class InputDevice
 * @packageName com.tykj.dev.rfid.entity.domin
 **/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update input_output_device set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("可出入库的装备,该表用于放置可以出库或者可以入库的装备")
public class InputOutputDevice {

    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 允许出入口的装备ID
     */
    @ApiModelProperty(value = "装备ID")
    private Integer deviceId;

    @ApiModelProperty(value = "rfid卡号")
    private String rfidCardId;

    @ApiModelProperty(value = "报警单位")
    private Integer unitId;

    @ApiModelProperty(value = "门禁是否已读(0:未读，1:已读)")
    private Integer isRead = 0;

    /**
     * 允许出入库的方向   0为入  1为出
     */
    @ApiModelProperty(value = "允许出入库的方向   0为入  1为出")
    private Integer direction;

    /**
     * 创建时间
     */
    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;
}
