package com.tykj.dev.rfid.entity.domin;

import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.rfid.entity.enums.RfidChangeStatus;
import com.tykj.dev.rfid.entity.vo.RfidFormVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for rfid_change_bill
 * RFID修改记录账单
 *
 * @author admin
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@Entity
@SQLDelete(sql = "update rfid_change_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("RFID修改记录账单")
public class RfidChangeBill {


    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 经办人id(A岗)
     */
    @ApiModelProperty(value = "经办人id(A岗)")
    private Integer userAId;
    /**
     * 审核人id(B岗)
     */
    @ApiModelProperty(value = "审核人id(B岗)")
    private Integer userBId;
    /**
     * 创建用户id
     */
    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;
    /**
     * 更新用户id
     */
    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;
    /**
     * 修改单位
     */
    @ApiModelProperty(value = "修改单位")
    private Integer unit;
    /**
     * 状态(0未完成，1审核失败，2审核成功)
     */
    @ApiModelProperty(value = "状态(0未完成，1审核失败，2审核成功)")
    private Integer status;
    /**
     * 附件文件名
     */
    @ApiModelProperty(value = "附件文件名")
    private String fileName;
    /**
     * 附件文件地址URL
     */
    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "附件文件地址URL")
    private String fileUrl;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    public RfidChangeBill(Integer userAId, Integer userBId, Integer unit, Integer status, String fileName, String fileUrl) {
        this.userAId = userAId;
        this.userBId = userBId;
        this.unit = unit;
        this.status = status;
        this.fileName = fileName;
        this.fileUrl = fileUrl;
    }

    public static RfidChangeBill formVoToBill(RfidFormVo formVo, User user) {
        return new RfidChangeBill(
                user.getUserId(),
                formVo.getConfirmId(),
                user.getUnits().getUnitId(),
                RfidChangeStatus.NEED_CONFIRM.getStatus(),
                formVo.getFileName(),
                formVo.getFileUrl()
        );
    }
}
