package com.tykj.dev.rfid.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * entity class for rfid_change_log
 * RFID修改日志
 *
 * @author admin
 */
@Data
@ApiModel("RFID修改日志详情返回给前端用的类")
public class RfidChangeLogResultVo {

    @ApiModelProperty(name = "主键id")
    private Integer id;

    @ApiModelProperty(value = "修改单位")
    private String unit;

    @ApiModelProperty(value = "修改人A")
    private Integer userAId;

    @ApiModelProperty(value = "修改人B")
    private Integer userBId;

    @ApiModelProperty(value = "旧rfid卡号")
    private String oldCardId;

    @ApiModelProperty(value = "新rfid卡号")
    private String newCardId;

    @ApiModelProperty(value = "修改人A名称")
    private String userAName;

    @ApiModelProperty(value = "修改人B名称")
    private String userBName;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "装备名称")
    private String name;

    @ApiModelProperty(value = "类型")
    private Integer type;

    @ApiModelProperty(value = "rfid表面号")
    private String rfidSurfaceId;

    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;

    @ApiModelProperty(value = "生产序列号")
    private String prodNumber;

    @ApiModelProperty(value = "所属单位")
    private String ownUnit;

    @ApiModelProperty(value = "所在单位")
    private String locationUnit;


}
