package com.tykj.dev.rfid.entity.vo;

import com.tykj.dev.misc.base.CustomPage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.Arrays;
import java.util.Date;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class InventoryLogSelectVo
 * @packageName com.tykj.dev.rfid.entity.vo
 **/
@Data
@ApiModel("库房报警记录查询类")
public class WarehouseLogSelectVo extends CustomPage {

    @ApiModelProperty("查询开始时间")
    private Date startTime;

    @ApiModelProperty("查询结束时间")
    private Date endTime;

    public LibraryWarningLogSelectVo toWarningVo() {
        LibraryWarningLogSelectVo libraryWarningLogSelectVo = new LibraryWarningLogSelectVo();
        BeanUtils.copyProperties(this, libraryWarningLogSelectVo);
        libraryWarningLogSelectVo.setWarningType(Arrays.asList(2));
        return libraryWarningLogSelectVo;
    }
}
