package com.tykj.dev.rfid.service;

import com.tykj.dev.rfid.entity.domin.InputOutputDevice;

import java.util.List;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class InputOutputDeviceService
 * @packageName com.tykj.dev.rfid.service
 **/
public interface InputOutputDeviceService {

    /**
     * 新增实体
     * @param inputOutputDevice
     * @return
     */
    void addEntity(InputOutputDevice inputOutputDevice);

    void sendHash(InputOutputDevice inputOutputDevice);

    /**
     * @param inputOutputDevices 异步上链
     */
    void sendHash(List<InputOutputDevice> inputOutputDevices);

    List<InputOutputDevice> getByUnitIdAndDirection(Integer unitId,Integer direction);

    void deleteAll(List<InputOutputDevice> inputOutputDevices);

    /**
     * @param deviceIds 允许出入库的装备id列表
     * @param unitId 出入库的单位
     * @param direction 允许出入库的方向   0为入  1为出
     */
    void addWhiteDevices(List<Integer> deviceIds,Integer unitId,Integer direction);

    /**
     * 设置白名单已经被读取到
     */
    void setRead(List<InputOutputDevice> inputOutputDevices);
}
