package com.tykj.dev.device.scrap.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.config.base.DeviceLifeStatus;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.FileVo;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.scrap.service.ScrapBillService;
import com.tykj.dev.device.scrap.subject.domin.ScrapBill;
import com.tykj.dev.device.scrap.subject.vo.ScrapSaveVo;
import com.tykj.dev.device.scrap.subject.vo.ScrapSelectVo;
import com.tykj.dev.device.scrap.subject.vo.UploadVo;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.util.UserUtils;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import com.tykj.dev.misc.utils.TaskDisposeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zjm
 */
@RestController
@RequestMapping(value = "/scrap")
@AutoDocument
@Api(tags = "报废模块", description = "报废模块")
public class DeviceScrapController {

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private ScrapBillService scrapBillService;

    @Autowired
    private UserUtils userUtils;
    
    @Autowired
    private TaskService taskService;

    @Autowired
    private DeviceLogService deviceLogService;

    @Autowired
    private DeviceLibraryDao deviceLibraryDao;

    @ApiOperation(value = "查询列表", notes = "可以通过这个接口查询销毁单")
    @PostMapping(value = "/summary")
    public ResponseEntity selectRepairBill(@RequestBody ScrapSelectVo scrapSelectVo) {
        return ResponseEntity.ok(scrapBillService.getPage(scrapSelectVo));
    }


    @ApiOperation(value = "查询列表详情", notes = "可以通过这个接口查询销毁单")
    @PostMapping(value = "/summary/{scrapId}")
    public ResponseEntity selectRepairBill1(@PathVariable Integer scrapId) {
        Map<Integer,DeviceLibrary> deviceLibraryMap = deviceLibraryService.getAllDeviceMap();
        List<Object> list = new ArrayList<>();
        ScrapBill scrapBill = scrapBillService.getOne(scrapId);
        if (scrapBill.getScriptJson()!=null){
            scrapBill.setScripts(JacksonUtil.readValue(scrapBill.getScriptJson(),new TypeReference<List<ScriptSaveVo>>() {}));
        }
        list.add(scrapBill);
        List<DeviceLibrary> deviceLibraries = StringSplitUtil.userIdSplit(scrapBill.getScrapDetail()).stream()
                .map(deviceLibraryMap::get)
                .collect(Collectors.toList());
        list.add(deviceLibraries);
        return ResponseEntity.ok(list);
    }

    @ApiOperation(value = "发起报废", notes = "发起报废单")
    @PostMapping(value = "/form")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity commitScrap(@RequestBody @Validated ScrapSaveVo scrapSaveVo) {
        deviceLibraryService.isWaitRetired(scrapSaveVo.getDeviceIds());
        //转实体类
        ScrapBill scrapBill = scrapSaveVo.toDo();
        //计算所有不同的型号
        Set<String> models = scrapSaveVo.getDeviceIds().stream().map(integer -> deviceLibraryService.getOne(integer).getModel()).collect(Collectors.toSet());
        StringBuffer stringBuffer = new StringBuffer();
        models.forEach(s -> stringBuffer.append(s).append(","));
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        scrapBill.setModels(stringBuffer.toString());
        //计算所有不同的名称
        Set<String> names = scrapSaveVo.getDeviceIds().stream().map(integer -> deviceLibraryService.getOne(integer).getName()).collect(Collectors.toSet());
        StringBuffer stringBuffer2 = new StringBuffer();
        names.forEach(s -> stringBuffer2.append(s).append(","));
        stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        scrapBill.setNames(stringBuffer2.toString());
        scrapBill.setScriptJson(JacksonUtil.toJSon(scrapSaveVo.getScriptSaveVos()));
        ScrapBill scrapBill1 = scrapBillService.add(scrapBill);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(Calendar.YEAR);
        String num = "NO:第" + year + "BF" + scrapBill1.getId() + "号";
        scrapBill1.setDocNumber(num);
        ScrapBill scrapBill2 = scrapBillService.update(scrapBill1);
        //发起任务
        Integer userId = userUtils.getCurrentUserId();
        List<Integer> userIds = new ArrayList<>();
        userIds.add(userId);
        userIds.add(0);
        TaskBto taskBto = new TaskBto(StatusEnum.WAIT_UPLOAD_SCRAP_FILE.id, "报废业务", null, ".", scrapBill2.getId(), 23, userUtils.getCurrentUnitId(), 1, null, userIds);
        taskService.start(taskBto);
        //添加装备日志
        for (Integer id:scrapSaveVo.getDeviceIds()) {
            DeviceLibrary deviceLibrary = deviceLibraryService.getOne(id);
            deviceLibrary.setLifeStatus(DeviceLifeStatus.IN_THE_SCRAPPED.id);
            deviceLibraryService.update(deviceLibrary);
            DeviceLogDto deviceLogDto = new DeviceLogDto(id,"发起报废",null);
            deviceLogService.addLog(deviceLogDto);
        }
        return selectRepairBill1(taskBto.getBillId());
    }

    @ApiOperation(value = "上传报废单", notes = "上传报废单")
    @PostMapping(value = "/upload")
    @Transactional(rollbackFor = Exception.class)
    public ResponseEntity uploadScrap(@RequestBody @Validated UploadVo uploadVo) {
        TaskBto taskBto = taskService.get(uploadVo.getTaskId());
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.WAIT_UPLOAD_SCRAP_FILE);
        ScrapBill scrapBill = scrapBillService.getOne(taskBto.getBillId());
        scrapBill.setFileName(uploadVo.getFileName());
        scrapBill.setFileUrl(uploadVo.getFileUrl());
        scrapBill.setUndertaker(uploadVo.getUndertaker());
        scrapBill.setLeader(uploadVo.getLeader());
        scrapBill.setSupervisor(uploadVo.getSupervisor());
        scrapBillService.update(scrapBill);
        taskService.addInvolveUser(taskBto,userUtils.getCurrentUserId());
        taskService.moveToEnd(taskBto);
        List<Integer> ids=StringSplitUtil.userIdSplit(scrapBill.getScrapDetail());
        deviceLibraryDao.upDateLeftStatus(DeviceLifeStatus.SCRAP_I.id,ids);
        List<FileVo> fileVos = new ArrayList<>();
        fileVos.add(new FileVo("报废单", scrapBill.getFileName(), scrapBill.getFileUrl()));
        //添加装备日志
        for (Integer id:StringSplitUtil.userIdSplit(scrapBill.getScrapDetail())) {
            DeviceLogDto deviceLogDto = new DeviceLogDto(id,"上传报废单",fileVos);
            deviceLogService.addLog(deviceLogDto);
        }
        return ResponseEntity.ok("上传成功");
    }

}
