package com.tykj.dev.device.scrap.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.scrap.service.ScrapBusinessService;
import com.tykj.dev.device.scrap.subject.vo.ScrapOrderOutData;
import com.tykj.dev.device.scrap.subject.vo.StorageScrap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelDevController.java
 * @Description TODO
 * @createTime 2021年01月10日 13:52:00
 */
@RestController
@Api(tags = "装备退役业务接口模块", description = "包括装备退役业务相关接口")
@AutoDocument
@RequestMapping("/scrapBusiness")
public class ScrapBusinessController {

    @Autowired
    ScrapBusinessService scrapBusinessService;

    /**
     * 省清退中办
     */
    @ApiOperation(value = "省清退中办", notes = "省清退中办")
    @PostMapping(value ="/provinceSendOutSuperior/{userId}")
    public ResponseEntity provinceSendOutSuperior(@PathVariable Integer userId, @RequestBody ScrapOrderOutData scrapOrderOutData){
//        repelBusinessService.provinceSendOutSuperior(userId,orderOutData);
        return ResponseEntity.ok(scrapBusinessService.provinceScrap(userId,scrapOrderOutData));
    }

    /**
     * 省上传中办回执单
     */
    @ApiOperation(value = "省上传中办回执单", notes = "省上传中办回执单")
    @PostMapping(value ="/receiptSingle/{taskId}")
    public ResponseEntity receiptSingle(@PathVariable Integer taskId, @RequestBody StorageScrap storageScrap){
        scrapBusinessService.receiptSingle(taskId,storageScrap);
        return ResponseEntity.ok("省上传中办回执单,成功任务结束");
    }


}
