package com.tykj.dev.device.scrap.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.scrap.service.ScrapQueryService;
import com.tykj.dev.device.scrap.subject.vo.ScrapSelectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelQueryController.java
 * @Description TODO
 * @createTime 2021年01月10日 15:43:00
 */
@RestController
@Api(tags = "装备退役查询接口模块", description = "包括装备清退、装备异常处理、装备出库、装备入库")
@AutoDocument
@RequestMapping("/scrapQuery")
public class ScrapQueryController {

    @Autowired
    ScrapQueryService scrapQueryService;

    @GetMapping(value ="/detail/{taskId}")
    @ApiOperation(value = "查询报废单据详情", notes = "查询报废单据详情")
    public ResponseEntity clearedList4(@PathVariable Integer taskId){
        return ResponseEntity.ok(scrapQueryService.findTaskId(taskId));
    }


    @PostMapping(value ="/listPage")
    @ApiOperation(value = "分页查询报废清单", notes = "分页查询报废清单")
    public ResponseEntity clearedList4(@RequestBody ScrapSelectVo scrapSelectVo){
        return ResponseEntity.ok(scrapQueryService.findPageScrapList(scrapSelectVo));
    }

}
