package com.tykj.dev.device.scrap.service;

import com.tykj.dev.device.scrap.subject.domin.Scrap;
import com.tykj.dev.device.scrap.subject.vo.ScrapSelectVo;
import org.springframework.data.domain.Page;

import java.util.List;

public interface ScrapService {
    /**
     * 添加报废详情
     * @return 报废详情对象
     */
    Scrap saveScrap(Scrap scrap);

    /**
     * 根据报废详情id查询清退详情
     * @param scrapId 报废详情id
     * @return 详情对象
     */
    Scrap findScrap(Integer scrapId);

    /**
     * 根据报废详情id查询清退详情（不包括装备详情）
     * @param scrapId 报废详情id
     * @return 详情对象
     */
    Scrap findScrapNoDev(Integer scrapId);

    /**
     * 查询所有的报废任务
     */
    List<Scrap> findAll();

    Page<Scrap> findPageScrapList(ScrapSelectVo scrapSelectVo);
}
