package com.tykj.dev.device.scrap.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.config.base.DeviceLifeStatus;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLogService;
import com.tykj.dev.device.library.subject.Dto.DeviceLogDto;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.domin.DeviceLog;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.scrap.service.ScrapBusinessService;
import com.tykj.dev.device.scrap.service.ScrapService;
import com.tykj.dev.device.scrap.subject.domin.Scrap;
import com.tykj.dev.device.scrap.subject.vo.ScrapOrderOutData;
import com.tykj.dev.device.scrap.subject.vo.StorageScrap;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.read.subject.bto.MessageBto;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.misc.base.BusinessEnum;
import com.tykj.dev.misc.base.StatusEnum;
import com.tykj.dev.misc.utils.DeviceSeqUtil;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.StringUtils;
import com.tykj.dev.misc.utils.TaskDisposeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ScrapBusinessServiceImpl.java
 * @Description TODO
 * @createTime 2021年03月31日 13:16:00
 */
@Service
@SuppressWarnings("ALL")
public class ScrapBusinessServiceImpl implements ScrapBusinessService {
    @Autowired
    UserService userService;

    @Autowired
    UnitsService unitsService;

    @Autowired
    ScrapService scrapService;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;

    @Autowired
    TaskService taskService;

    @Autowired
    DeviceLogService deviceLogService;

    @Autowired
    MessageService messageService;

    @Override
    public Scrap provinceScrap(Integer userId, ScrapOrderOutData scrapOrderOutData) {
        User user = userService.findByUser(userId);
        Units units=unitsService.findById(user.getUnitsId());
        Scrap scrap=scrapOrderOutData.toScrap();
        scrap.setDeviceIds(StringUtils.ListToString(scrapOrderOutData.getDevIds()));
        scrap.setOutboundFile(FilesUtil.stringFileToList(scrapOrderOutData.getOutboundFileList()));
        scrapService.saveScrap(scrap);
        scrap.setScripts(scrapOrderOutData.getScriptSaveVos());
        scrap.setScriptJson(JacksonUtil.toJSon(scrapOrderOutData.getScriptSaveVos()));
        scrap.setNum("NO:第"+ LocalDateTime.now().getYear()+"QT"+scrap.getId());
        List<DeviceLibrary> deviceLibraries= findInvoleDevice(scrap.getDeviceIds());
        scrap.setDeviceLibraryEntities(findInvoleDevice(scrap.getDeviceIds()));
        scrapService.saveScrap(scrap);
        List<ScriptSaveVo> scriptSaveVos=scrapOrderOutData.getScriptSaveVos();
        List<String> seqNumbers=new ArrayList<>();
        scriptSaveVos.forEach(
                scriptSaveVo -> {
                    if (scriptSaveVo.getSeqNumber()!=null){
                        seqNumbers.addAll(DeviceSeqUtil.selectDeviceSeqs(scriptSaveVo.getSeqNumber()));
                    }
                }
        );
        deviceLibraryDao.upDateSeqNumbersLeftStatus(DeviceLifeStatus.RETIRED.id,seqNumbers);
        devLogAdd(deviceLibraries,"发起了报废任务",userId);
        TaskBto taskBto= sendOutSuperior(units.getUnitId(),scrap.getId(),userId);
        addMessage(new MessageBto(taskBto.getId(),taskBto.getBusinessType(),"发起退役任务,待上传回执单据",gainThisUser(user.getUserId(),user.getUnitsId())));
        return scrap;
    }


    @Override
    public void receiptSingle(Integer taskId, StorageScrap storageScrap) {
        User user=userService.findByUser(storageScrap.getUserId());
        TaskBto taskBto= taskService.get(taskId);
        TaskDisposeUtil.isNotSubmit(taskBto.getBillStatus(),StatusEnum.SEND_BACK_1210);
        Scrap scrap=scrapService.findScrap(taskBto.getBillId());
        scrap.setBillFile(FilesUtil.stringFileToList(storageScrap.getFileRets()));
        if (storageScrap.getUserBName()!=null) {
            scrap.setReceiveUserB(storageScrap.getUserBName());
        }
        if (storageScrap.getUserB()!=null){
            scrap.setReceiveUserbId(storageScrap.getUserB());

        }
        if (storageScrap.getUserA()!=null){
            scrap.setReceiveUseraId(storageScrap.getUserA());

        }
        if (storageScrap.getUserAName()!=null) {
            scrap.setReceiveUserA(storageScrap.getUserAName());
        }
        taskService.moveToEnd(taskBto);

        List<String> seqNumbers=new ArrayList<>();
        JacksonUtil.readValue(scrap.getScriptJson(), new TypeReference<List<ScriptSaveVo>>() {}).forEach(
                scriptSaveVo -> {
                    if (scriptSaveVo.getSeqNumber()!=null){
                        seqNumbers.addAll(DeviceSeqUtil.selectDeviceSeqs(scriptSaveVo.getSeqNumber()));
                    }
                }
        );
        deviceLibraryDao.upDateSeqNumbersLeftStatusAndUnitNameAndLockStatus(DeviceLifeStatus.RETIRE.id,scrap.getReceiveUnit(),0,seqNumbers);
        scrapService.saveScrap(scrap);
        devLogAdd(findInvoleDevice(scrap.getDeviceIds()),"上传了报废单据,装备状态-》已报废",storageScrap.getUserId());
        addMessage(new MessageBto(taskBto.getId(),taskBto.getBusinessType(),"退役任务回执单据上传成功任务结束",gainThisUser(user.getUserId(),user.getUnitsId())));
    }


    /**
     * 报废省出库中办
     * @param userId 当前用户对象
     * @param unitId 单位id
     * @param repelDetailId 业务id
     * @return
     */
    private TaskBto sendOutSuperior(Integer unitId, Integer repelDetailId,Integer userId){
        List<Integer> userIds = new ArrayList<>();
        userIds.add(userId);
        userIds.add(0);
      return   taskService.start(new TaskBto(StatusEnum.WAIT_UPLOAD_SCRAP_FILE.id, "报废业务", null, ".", repelDetailId, BusinessEnum.SCRAP.id, unitId, 1, "country", userIds));
    }

    /**
     * 异步添加装备日志
     * @param deviceLibraries
     * @param remark
     * @param userId
     */
    private void devLogAdd(List<DeviceLibrary> deviceLibraries, String remark, Integer userId){
        List<DeviceLog> logDtos=new ArrayList<>();
        deviceLibraries.forEach(
                deviceLibrary -> {
                    logDtos.add(new DeviceLogDto(deviceLibrary.getId(),remark,null,userId).toDo());

                }
        );
        CompletableFuture.runAsync(() -> {
            deviceLogService.saveAllLog(logDtos);
        });

    }

    private void addMessage(MessageBto messageBto){
        messageService.add(messageBto);
    }

    /**
     * 根据单位id查询用户 去除用户id
     * @param userId
     * @param unitId
     * @return
     */
    private List<Integer> gainThisUser(Integer userId,Integer unitId){
        return userService.findAllByUnite(unitId).stream().filter(user -> user.getUnitsId()!=userId).map(User::getUserId).collect(Collectors.toList());
    }

    /**
     * 根据单位id查询用户id集合
     * @param unitId
     * @return
     */
    private List<Integer> findUnitId(Integer unitId){
        return userService.findAllByUnite(unitId).stream().map(User::getUserId).collect(Collectors.toList());
    }

    private List<DeviceLibrary> findInvoleDevice(String involeDevice){
        if (involeDevice!=null && !involeDevice.equals(",") ) {
            List<String> idStringList = Arrays.asList(involeDevice.split(","));
            List<String> idListString = idStringList.stream().filter(list2->!list2.equals("")).collect(Collectors.toList());
            System.out.println(idListString);
            List<Integer> devIds = idListString.stream().map(Integer::parseInt).collect(Collectors.toList());
            return deviceLibraryDao.getDeviceLibraryEntitiesByIdIn(devIds).stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList());
        }else {
            return new ArrayList<>();
        }
    }
}
