package com.tykj.dev.device.scrap.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.scrap.service.ScrapQueryService;
import com.tykj.dev.device.scrap.service.ScrapService;
import com.tykj.dev.device.scrap.subject.domin.Scrap;
import com.tykj.dev.device.scrap.subject.domin.ScrapBill;
import com.tykj.dev.device.scrap.subject.vo.ScrapSelectVo;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import javax.persistence.Transient;
import java.lang.reflect.Field;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ScrapQueryServiceImpl.java
 * @Description TODO
 * @createTime 2021年03月31日 14:14:00
 */
@Service
public class ScrapQueryServiceImpl implements ScrapQueryService {
    @Autowired
    ScrapService scrapService;

    @Autowired
    TaskService taskService;

    @Override
    public Page<Scrap> findPageScrapList(ScrapSelectVo scrapSelectVo) {
    return scrapService.findPageScrapList(scrapSelectVo);
    }

    @Override
    public Scrap findTaskId(Integer taskId) {
        TaskBto taskBto= taskService.get(taskId);
        return scrapService.findScrap(taskBto.getBillId());
    }
}
