package com.tykj.dev.device.scrap.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.scrap.repository.ScrapDao;
import com.tykj.dev.device.scrap.service.ScrapService;
import com.tykj.dev.device.scrap.subject.domin.Scrap;
import com.tykj.dev.device.scrap.subject.domin.ScrapBill;
import com.tykj.dev.device.scrap.subject.vo.ScrapSelectVo;
import com.tykj.dev.misc.exception.ApiException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.persistence.Transient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName ScrapServiceImpl.java
 * @Description TODO
 * @createTime 2021年03月31日 10:23:00
 */
@Service
@Slf4j
public class ScrapServiceImpl implements ScrapService {
    @Autowired
    ScrapDao scrapDao;

    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Override
    public Scrap saveScrap(Scrap scrap) {
        return scrapDao.save(scrap);
    }

    @Override
    public Scrap findScrap(Integer scrapId) {
        Optional<Scrap> optional = scrapDao.findById(scrapId);
        if (optional.isPresent()){
            Scrap scrap=optional.get();
            scrap.setDeviceLibraryEntities(findInvoleDevice(scrap.getDeviceIds()));
            scrap.setBillFiles(FilesUtil.stringFileToList(scrap.getBillFile()));
            scrap.setOutboundFiles(FilesUtil.stringFileToList(scrap.getOutboundFile()));
            return scrap;
        }else {
            log.info("[报废] 详情查看错误，id没有找到{}",scrapId);
            throw new ApiException(ResponseEntity.status(500).body("报废详情id没有找到:"+scrapId));
        }    }

    @Override
    public Scrap findScrapNoDev(Integer scrapId) {
        Optional<Scrap> optional = scrapDao.findById(scrapId);
        if (optional.isPresent()){
            return optional.get();
        }else {
            log.info("[报废] 详情查看错误，id没有找到{}",scrapId);
            throw new ApiException(ResponseEntity.status(500).body("报废详情id没有找到:"+scrapId));
        }    }

    @Override
    public List<Scrap> findAll() {
        return scrapDao.findAll();
    }

    @Override
    public Page<Scrap> findPageScrapList(ScrapSelectVo scrapSelectVo) {
        PredicateBuilder<Scrap> predicateBuilder = Specifications.and();
        if (scrapSelectVo.getContent() != null) {
            Class<ScrapBill> scrapBillClass = ScrapBill.class;
            Field[] declaredFields = scrapBillClass.getDeclaredFields();
            PredicateBuilder<ScrapBill> p = Specifications.or();
            for (Field field : declaredFields) {
                if (field.getType().equals(String.class) && field.getAnnotation(Transient.class) == null) {
                    p.like(field.getName(), "%" + scrapSelectVo.getContent() + "%");
                }
            }
            predicateBuilder.predicate(p.build());
        }
        if (scrapSelectVo.getStartTime() != null) {
            predicateBuilder.gt("updateTime", scrapSelectVo.getStartTime());
        }
        if (scrapSelectVo.getEndTime() != null) {
            predicateBuilder.lt("updateTime", scrapSelectVo.getEndTime());
        }
        return scrapDao.findAll(predicateBuilder.build(), scrapSelectVo.getPageable());
    }


    private List<DeviceLibrary> findInvoleDevice(String involeDevice){
        if (involeDevice!=null && !involeDevice.equals(",") ) {
            List<String> idStringList = Arrays.asList(involeDevice.split(","));
            List<String> idListString = idStringList.stream().filter(list2->!list2.equals("")).collect(Collectors.toList());
            System.out.println(idListString);
            List<Integer> devIds = idListString.stream().map(Integer::parseInt).collect(Collectors.toList());
            return deviceLibraryDao.getDeviceLibraryEntitiesByIdIn(devIds).stream().map(DeviceLibrary::setConfigName).collect(Collectors.toList());
        }else {
            return new ArrayList<>();
        }
    }
}
