package com.tykj.dev.device.scrap.subject.domin;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tykj.dev.device.file.entity.Documents;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description DeviceRepel 清退业务id
 * @createTime 2021年01月06日 20:02:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@ApiModel("报废业务详情")
public class Scrap extends BaseEntity {

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "单据编号")
    private String num;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "发件单位")
    private String sendUnit;

    @ApiModelProperty(value = "发件单位id")
    private Integer sendUnitId;

    @ApiModelProperty(value = "收件单位id")
    private Integer receiveUnitId;

    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;

    @ApiModelProperty(value = "配发时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;

    @ApiModelProperty(value = "接收时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;

    @ApiModelProperty(value = "发件方id(A岗位)")
    private Integer sendUseraId;


    @ApiModelProperty(value = "发件方名称(A岗位)")
    private String senderUserA;

    @ApiModelProperty(value = "签发人(B岗位)")
    private String senderUserB;

    @ApiModelProperty(value = "签发人(B岗位)")
    private Integer sendUserbId;

    @ApiModelProperty(value = "收件方id(A岗位)")
    private Integer receiveUseraId;

    @ApiModelProperty(value = "收件方名称(A岗位)")
    private String receiveUserA;

    @ApiModelProperty(value = "收件方名称(B岗位)")
    private String receiveUserB;

    @ApiModelProperty(value = "收件方id(B岗位)")
    private Integer receiveUserbId;


    @ApiModelProperty(value = "回执单")
    @Column(name = "outbound_file",columnDefinition = "TEXT")
    private String outboundFile;


    @ApiModelProperty(value = "签收单")
    @Column(name = "bill_file",columnDefinition = "TEXT")
    private String billFile;

    /**
     * 退回状态(1:退回待审核,2:退回审核失败,3:退回中,4:退回接收待审核,5:退回接收审核失败,6:退回成功)
     */
    @ApiModelProperty(value = "退回状态(1:退回待审核,2:退回审核失败,3:退回中,4:退回接收待审核,5:退回接收审核失败,6:退回成功)")
    private Integer sendBackStatus;

    @ApiModelProperty(value = "装备id集合")
    @Column(name = "device_ids",columnDefinition = "TEXT")
    private String deviceIds;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "区块链RID",name = "recordId")
    private String recordId;

    @ApiModelProperty(value = "批复文号文件")
    @Column(name = "reply_files",columnDefinition = "TEXT")
    private String replyFiles;

    @ApiModelProperty(value = "申请文号文件")
    @Column(name = "apply_files",columnDefinition = "TEXT")
    private String applyFiles;

    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @Transient
    private List<ScriptSaveVo> scripts = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "批复文号文件集合")
    private List<FileRet> replyFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "申请文号文件集合")
    private List<FileRet> applyFileList = new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "装备List")
    private List<DeviceLibrary> deviceLibraryEntities =new ArrayList<>();

    @Transient
    @ApiModelProperty(value = "签收单文件集合对象")
    private List<FileRet> billFiles ;

    @Transient
    @ApiModelProperty(value = "回执单文件集合对象")
    private List<FileRet> outboundFiles ;


    public Documents toDoc(){
        return new Documents(num,"装备清退单据",receiveUnit,replayNumber,sendUnit,null,null,senderUserA,senderUserB,receiveUserA,receiveUserB,null);
    }

}
