package com.tykj.dev.device.scrap.subject.domin;

import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update scrap_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("装备报废账单")
public class ScrapBill {

    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    @ApiModelProperty(value = "维修单id")
    private Integer repairBillId;

    @ApiModelProperty(value = "报废单位")
    private String scrapUnit;

    @ApiModelProperty(value = "报废时间")
    private Date scrapTime;

    @ApiModelProperty(value = "文号")
    private String docNumber;

    @ApiModelProperty(value = "监销人")
    private String supervisor;

    @ApiModelProperty(value = "主管领导")
    private String leader;

    @ApiModelProperty(value = "经办人")
    private String manager;

    @ApiModelProperty(value = "承办人")
    private String undertaker;

    @ApiModelProperty(value = "报废单文件名")
    private String fileName;

    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "报废单文件URL")
    private String fileUrl;

    @Column(name = "scrap_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "报废装备主键Id以x拼接")
    private String scrapDetail;

    @Column(name = "models",columnDefinition = "TEXT")
    @ApiModelProperty(value = "报废型号，以,拼接")
    private String models;

    @Column(name = "names",columnDefinition = "TEXT")
    @ApiModelProperty(value = "报废名称，以,拼接")
    private String names;

    @ApiModelProperty(value = "创建用户id")
    @CreatedBy
    private Integer createUserId;

    @ApiModelProperty(value = "创建时间")
    @CreatedDate
    private Date createTime;

    @ApiModelProperty(value = "更新用户id")
    @LastModifiedBy
    private Integer updateUserId;

    @ApiModelProperty(value = "更新时间")
    @LastModifiedDate
    private Date updateTime;

    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;


    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @Transient
    private List<ScriptSaveVo> scripts = new ArrayList<>();

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;
}
